/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.compile.CompilationHost;
import com.azul.jvm.compile.CompilationTrigger;
import com.azul.jvm.compile.FalconTierKind;
import com.azul.jvm.compile.OptLevel;
import com.azul.jvm.compile.StashFlavor;
import com.azul.zing.profilelog.CompileOptionsVersion;
import java.util.Iterator;

public class CompileOptions {
    public static final int ENTRY_BCI = -2;
    public Integer osrBci = null;
    public CompilationTrigger trigger = null;
    public CompilationTrigger extraTrigger = null;
    public StashFlavor stashLookup = null;
    public CompilationHost compilationHost = null;
    public OptLevel optHint = null;
    public Boolean trySkipSignatureClassLoading = null;
    public Boolean skipConstantLoading = null;
    public Boolean priorityCompile = null;
    public Boolean withLvb = null;
    public Boolean evictableCompilation = null;
    public Long rnCompileId = null;
    public Integer group = null;
    public FalconTierKind falconTierKind = null;

    public static CompileOptions buildCompileOptions(Iterable<Long> options, Integer osrBci, CompileOptionsVersion version) {
        switch (version) {
            case V7: {
                return CompileOptions.compileOptions_v7(osrBci);
            }
            case V33: {
                return CompileOptions.compileOptions_v33(options);
            }
            case V59: {
                return CompileOptions.compileOptions_v59(options);
            }
        }
        throw new IllegalArgumentException("Unable to parse version of CompileOptions");
    }

    private static CompileOptions compileOptions_v7(Integer osrBci) {
        CompileOptions options = new CompileOptions();
        options.osrBci = osrBci;
        options.trigger = null;
        options.extraTrigger = null;
        options.stashLookup = null;
        options.compilationHost = null;
        options.optHint = null;
        options.trySkipSignatureClassLoading = null;
        options.skipConstantLoading = null;
        options.priorityCompile = null;
        options.withLvb = null;
        options.evictableCompilation = null;
        options.rnCompileId = null;
        options.group = null;
        options.falconTierKind = null;
        return options;
    }

    private static CompileOptions compileOptions_v33(Iterable<Long> options) {
        CompileOptions compileOptions = new CompileOptions();
        OptionParser parser = new OptionParser(options.iterator());
        compileOptions.osrBci = parser.nextBci();
        compileOptions.trigger = CompileOptions.decodeCompilationTrigger(parser.nextInt());
        compileOptions.extraTrigger = null;
        compileOptions.stashLookup = CompileOptions.decodeStashFlavor(parser.nextInt());
        compileOptions.optHint = CompileOptions.decodeOptLevel(parser.nextInt());
        compileOptions.trySkipSignatureClassLoading = parser.nextBoolean();
        compileOptions.skipConstantLoading = parser.nextBoolean();
        compileOptions.priorityCompile = parser.nextBoolean();
        compileOptions.withLvb = null;
        compileOptions.evictableCompilation = parser.nextBoolean();
        compileOptions.rnCompileId = parser.nextLong();
        compileOptions.group = null;
        compileOptions.falconTierKind = null;
        return compileOptions;
    }

    private static CompileOptions compileOptions_v59(Iterable<Long> options) {
        CompileOptions compileOptions = new CompileOptions();
        OptionParser parser = new OptionParser(options.iterator());
        compileOptions.osrBci = parser.nextBci();
        compileOptions.trigger = CompileOptions.decodeCompilationTrigger(parser.nextInt());
        compileOptions.extraTrigger = CompileOptions.decodeCompilationTrigger(parser.nextInt());
        compileOptions.stashLookup = CompileOptions.decodeStashFlavor(parser.nextInt());
        compileOptions.compilationHost = CompileOptions.decodeCompilationHost(parser.nextInt());
        compileOptions.optHint = CompileOptions.decodeOptLevel(parser.nextInt());
        compileOptions.trySkipSignatureClassLoading = parser.nextBoolean();
        compileOptions.skipConstantLoading = parser.nextBoolean();
        compileOptions.priorityCompile = parser.nextBoolean();
        compileOptions.withLvb = parser.nextBoolean();
        compileOptions.evictableCompilation = parser.nextBoolean();
        compileOptions.rnCompileId = parser.nextLong();
        compileOptions.group = parser.nextInt();
        compileOptions.falconTierKind = CompileOptions.decodeFalconTierKind(parser.nextInt());
        return compileOptions;
    }

    private static OptLevel decodeOptLevel(int value) {
        switch (value) {
            case 0: {
                return OptLevel.O0;
            }
            case 1: {
                return OptLevel.O1;
            }
            case 2: {
                return OptLevel.O2;
            }
            case 3: {
                return OptLevel.O3;
            }
            case -1: {
                return OptLevel.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown value of falcon optimization level in compile options: " + value);
    }

    private static CompilationTrigger decodeCompilationTrigger(int value) {
        switch (value) {
            case -1: 
            case 0: {
                return CompilationTrigger.UNKNOWN;
            }
            case 1: {
                return CompilationTrigger.SOFT;
            }
            case 2: {
                return CompilationTrigger.HARD;
            }
        }
        throw new IllegalArgumentException("Unknown value of trigger in compile options: " + value);
    }

    private static CompilationHost decodeCompilationHost(int value) {
        switch (value) {
            case 0: {
                return CompilationHost.LOCAL;
            }
            case 1: {
                return CompilationHost.REMOTE;
            }
        }
        throw new IllegalArgumentException("Unknown value of compilationHost in compile options: " + value);
    }

    private static FalconTierKind decodeFalconTierKind(int value) {
        switch (value) {
            case 0: {
                return FalconTierKind.DEFAULT;
            }
            case 1: {
                return FalconTierKind.MID;
            }
            case 2: {
                return FalconTierKind.FINAL;
            }
        }
        throw new IllegalArgumentException("Unknown value of falconTierKind in compile options: " + value);
    }

    private static StashFlavor decodeStashFlavor(int value) {
        switch (value) {
            case 0: {
                return StashFlavor.DEFAULT;
            }
            case 1: {
                return StashFlavor.ONLY_LOOKUP;
            }
            case 2: {
                return StashFlavor.SKIP_LOOKUP;
            }
        }
        throw new IllegalArgumentException("Unknown value of stash lookup in compile options: " + value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.osrBci != null) {
            sb.append("osrBci: ").append(this.osrBci).append(' ');
        }
        if (this.trigger != null) {
            sb.append("trigger: ").append((Object)this.trigger).append(' ');
        }
        if (this.extraTrigger != null) {
            sb.append("extraTrigger: ").append((Object)this.extraTrigger).append(' ');
        }
        if (this.stashLookup != null) {
            sb.append("stashLookup: ").append((Object)this.stashLookup).append(' ');
        }
        if (this.compilationHost != null) {
            sb.append("compilationHost: ").append((Object)this.compilationHost).append(' ');
        }
        if (this.optHint != null) {
            sb.append("optHint: ").append((Object)this.optHint).append(' ');
        }
        if (this.trySkipSignatureClassLoading != null) {
            sb.append("trySkipSignatureClassLoading: ").append(this.trySkipSignatureClassLoading).append(' ');
        }
        if (this.skipConstantLoading != null) {
            sb.append("skipConstantLoading: ").append(this.skipConstantLoading).append(' ');
        }
        if (this.priorityCompile != null) {
            sb.append("priorityCompile: ").append(this.priorityCompile).append(' ');
        }
        if (this.withLvb != null) {
            sb.append("withLvb: ").append(this.withLvb).append(' ');
        }
        if (this.evictableCompilation != null) {
            sb.append("evictableCompilation: ").append(this.evictableCompilation).append(' ');
        }
        if (this.rnCompileId != null) {
            sb.append("rnCompileId: ").append(this.rnCompileId);
        }
        if (this.group != null) {
            sb.append("group: ").append(this.group).append(' ');
        }
        if (this.falconTierKind != null) {
            sb.append("falconTierKind: ").append((Object)this.falconTierKind).append(' ');
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            sb.setLength(sb.length() - 1);
        }
        return sb.append('}').toString();
    }

    public boolean isOsr() {
        return this.osrBci != null;
    }

    private static final class OptionParser {
        private final Iterator<Long> rawOptions;

        OptionParser(Iterator<Long> rawOptions) {
            this.rawOptions = rawOptions;
        }

        Integer nextBci() {
            int value = this.rawOptions.next().intValue();
            return value == -2 ? null : Integer.valueOf(value);
        }

        int nextInt() {
            return this.rawOptions.next().intValue();
        }

        long nextLong() {
            return this.rawOptions.next();
        }

        boolean nextBoolean() {
            return this.nextLong() == 1L;
        }
    }
}

