/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.jvm.klass.KlassBuilder;
import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.zing.profilelog.ProfileLogProcessor;
import com.azul.zing.profilelog.ProfiledArray;
import com.azul.zing.profilelog.ProfiledClass;
import com.azul.zing.profilelog.ProfiledClassMatch;
import com.azul.zing.profilelog.ProfiledInitiatingLoader;
import com.azul.zing.profilelog.ProfiledPrimitiveArray;
import java.util.Map;
import java.util.Objects;

public class KlassModelBuilder
extends ProfileLogProcessor.Base {
    private final Map<PersistentKlassId, KlassBuilder> store;

    public KlassModelBuilder(Map<PersistentKlassId, KlassBuilder> store) {
        this.store = Objects.requireNonNull(store, "store");
    }

    @Override
    public void process(ProfiledArray array) {
        KlassBuilder builder = this.getOrAddKlassBuilder(array.classId);
        builder.setKind(KlassKind.CLASS);
        KlassBuilder elementKlass = this.getOrAddKlassBuilder(array.elementClassId);
        if (elementKlass.getDefiningLoaderId() != null) {
            KlassBuilder.fillArray(builder, elementKlass, array.dimension);
        } else {
            elementKlass.addPendingArray(builder, array.dimension);
        }
    }

    @Override
    public void process(ProfiledPrimitiveArray primitiveArray) {
        KlassLoaderId klassLoaderId = KlassLoaderId.of(primitiveArray.loaderId);
        PersistentKlassId klassId = primitiveArray.classId;
        KlassBuilder builder = this.getOrAddKlassBuilder(klassId);
        builder.setKind(KlassKind.CLASS);
        builder.setName(primitiveArray.name);
        builder.setDefiningLoaderId(klassLoaderId);
        builder.processPendingArrays();
    }

    @Override
    public void process(ProfiledClass klass) {
        PersistentKlassId klassId = klass.id;
        KlassLoaderId klassLoaderId = klass.loaderId;
        KlassBuilder builder = this.getOrAddKlassBuilder(klassId);
        builder.setKind(klass.kind);
        builder.setName(klass.name);
        builder.setDefiningLoaderId(klassLoaderId);
        builder.processPendingArrays();
    }

    @Override
    public void process(ProfiledInitiatingLoader initiatingLoader) {
        KlassBuilder builder = this.getOrAddKlassBuilder(initiatingLoader.classId);
        builder.setInitiatingLoaderId(KlassLoaderId.of(initiatingLoader.loaderId));
    }

    @Override
    public void process(ProfiledClassMatch classMatch) {
        KlassBuilder builder = this.getOrAddKlassBuilder(classMatch.classId);
        builder.setPrevId(classMatch.oldClassId);
    }

    private KlassBuilder getOrAddKlassBuilder(PersistentKlassId id) {
        return this.store.computeIfAbsent(id, KlassBuilder::new);
    }
}

