/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.text.GulpText;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import com.azul.zing.profilelog.internals.ProfiledInterpCountersLineMatcher;
import java.util.Collections;
import java.util.List;

@GulpText.LineMatchers(value={@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class), @GulpText.LineMatcher(value=ProfiledInterpCountersLineMatcher.class)})
@ProfileRecord(value="MethodData")
public final class ProfiledMethodData {
    public final PersistentMethodId methodId;
    public final CompilationId compileId;
    public final Long profileId;
    public final int invocation;
    public final int backedge;
    public final long min_time_between_promotions_ms;
    public final boolean disableCountedLoopSpeculation;
    public final List<Integer> uniqueBcis;

    public ProfiledMethodData(long methodId, int compileId, int invocation, int backedge) {
        this.methodId = PersistentMethodId.of(methodId);
        this.compileId = CompilationId.of(compileId);
        this.profileId = null;
        this.invocation = invocation;
        this.backedge = backedge;
        this.min_time_between_promotions_ms = -1L;
        this.disableCountedLoopSpeculation = false;
        this.uniqueBcis = Collections.emptyList();
    }

    @ProfileVersion(value=14)
    public ProfiledMethodData(long methodId, int compileId, int invocation, int backedge, boolean disableCountedLoopSpeculation, List<Integer> uniqueBcis) {
        this.methodId = PersistentMethodId.of(methodId);
        this.compileId = CompilationId.of(compileId);
        this.profileId = null;
        this.invocation = invocation;
        this.backedge = backedge;
        this.min_time_between_promotions_ms = -1L;
        this.disableCountedLoopSpeculation = disableCountedLoopSpeculation;
        this.uniqueBcis = uniqueBcis;
    }

    @ProfileVersion(value=26)
    public ProfiledMethodData(long profileId, int invocation, int backedge, boolean disableCountedLoopSpeculation, List<Integer> uniqueBcis) {
        this.methodId = null;
        this.compileId = null;
        this.profileId = profileId;
        this.invocation = invocation;
        this.backedge = backedge;
        this.min_time_between_promotions_ms = -1L;
        this.disableCountedLoopSpeculation = disableCountedLoopSpeculation;
        this.uniqueBcis = uniqueBcis;
    }

    @ProfileVersion(value=54)
    public ProfiledMethodData(long profileId, int invocation, int backedge, long min_time_between_promotions_ms, boolean disableCountedLoopSpeculation, List<Integer> uniqueBcis) {
        this.methodId = null;
        this.compileId = null;
        this.profileId = profileId;
        this.invocation = invocation;
        this.backedge = backedge;
        this.min_time_between_promotions_ms = min_time_between_promotions_ms;
        this.disableCountedLoopSpeculation = disableCountedLoopSpeculation;
        this.uniqueBcis = uniqueBcis;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("MethodData: ");
        if (this.profileId != null) {
            sb.append(this.profileId);
        } else {
            sb.append("method: ").append(this.methodId).append(" compilation: ").append(this.compileId);
        }
        sb.append(" invocationCount: ").append(this.invocation).append(" backedgeCount: ").append(this.backedge).append(" min_time_between_promotions_ms: ").append(this.min_time_between_promotions_ms).append(" disableLoopSpec: ").append(this.disableCountedLoopSpeculation).append(" uniqueBcis: ").append(this.uniqueBcis);
        return sb.toString();
    }
}

