/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.Gulp;
import com.azul.gulp.text.GulpText;
import com.azul.jvm.compile.CompilationId;
import com.azul.jvm.compile.PersistedTierKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.EpochTime;
import com.azul.zing.profilelog.CompileOptions;
import com.azul.zing.profilelog.CompileOptionsVersion;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import java.util.Collections;
import java.util.List;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="C2Compilation")
public final class ProfiledTier2Compilation {
    @Gulp.Capture
    public EpochTime epochTime;
    public final PersistentMethodId methodId;
    public final CompilationId compileId;
    public final List<PersistentMethodId> inlinedMethodIds;
    public final List<Integer> profileRefIds;
    public final List<PersistentKlassId> loadedClassIds;
    public final List<PersistentKlassId> linkedClassIds;
    public final List<PersistentKlassId> initializedClassIds;
    public final List<PersistentKlassId> hierarchyClassIds;
    public final PersistedTierKind tierKind;
    public final CompileOptions compileOptions;

    @ProfileVersion(value=7)
    public ProfiledTier2Compilation(long methodId, int compileId, List<PersistentMethodId> inlinedMethodIds, List<PersistentKlassId> initializedClassIds, List<PersistentKlassId> hierarchyClassIds, Integer osrBci) {
        this.methodId = PersistentMethodId.of(methodId);
        this.compileId = CompilationId.of(compileId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.emptyList();
        this.loadedClassIds = Collections.emptyList();
        this.linkedClassIds = Collections.emptyList();
        this.initializedClassIds = Collections.unmodifiableList(initializedClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierarchyClassIds);
        this.tierKind = PersistedTierKind.UNAVAILABLE;
        this.compileOptions = CompileOptions.buildCompileOptions(null, osrBci, CompileOptionsVersion.V7);
    }

    @ProfileVersion(value=19)
    public ProfiledTier2Compilation(long methodId, int compileId, List<PersistentMethodId> inlinedMethodIds, List<PersistentKlassId> linkedClassIds, List<PersistentKlassId> initializedClassIds, List<PersistentKlassId> hierarchyClassIds, Integer osrBci) {
        this.methodId = PersistentMethodId.of(methodId);
        this.compileId = CompilationId.of(compileId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.emptyList();
        this.loadedClassIds = Collections.emptyList();
        this.linkedClassIds = Collections.unmodifiableList(linkedClassIds);
        this.initializedClassIds = Collections.unmodifiableList(initializedClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierarchyClassIds);
        this.tierKind = PersistedTierKind.UNAVAILABLE;
        this.compileOptions = CompileOptions.buildCompileOptions(null, osrBci, CompileOptionsVersion.V7);
    }

    @ProfileVersion(value=29)
    public ProfiledTier2Compilation(int compileId, long methodId, List<PersistentMethodId> inlinedMethodIds, List<Integer> profileRefIds, List<PersistentKlassId> linkClassIds, List<PersistentKlassId> initClassIds, List<PersistentKlassId> hierClassIds, Integer osrBci) {
        this.compileId = CompilationId.of(compileId);
        this.methodId = PersistentMethodId.of(methodId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.unmodifiableList(profileRefIds);
        this.loadedClassIds = Collections.emptyList();
        this.linkedClassIds = Collections.unmodifiableList(linkClassIds);
        this.initializedClassIds = Collections.unmodifiableList(initClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierClassIds);
        this.tierKind = PersistedTierKind.UNAVAILABLE;
        this.compileOptions = CompileOptions.buildCompileOptions(null, osrBci, CompileOptionsVersion.V7);
    }

    @ProfileVersion(value=33)
    public ProfiledTier2Compilation(int compileId, long methodId, List<PersistentMethodId> inlinedMethodIds, List<Integer> profileRefIds, List<PersistentKlassId> linkClassIds, List<PersistentKlassId> initClassIds, List<PersistentKlassId> hierClassIds, List<Long> compileOptions) {
        this.compileId = CompilationId.of(compileId);
        this.methodId = PersistentMethodId.of(methodId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.unmodifiableList(profileRefIds);
        this.loadedClassIds = Collections.emptyList();
        this.linkedClassIds = Collections.unmodifiableList(linkClassIds);
        this.initializedClassIds = Collections.unmodifiableList(initClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierClassIds);
        this.tierKind = PersistedTierKind.UNAVAILABLE;
        this.compileOptions = CompileOptions.buildCompileOptions(compileOptions, null, CompileOptionsVersion.V33);
    }

    @ProfileVersion(value=42)
    public ProfiledTier2Compilation(int compileId, long methodId, List<PersistentMethodId> inlinedMethodIds, List<Integer> profileRefIds, List<PersistentKlassId> loadClassIds, List<PersistentKlassId> linkClassIds, List<PersistentKlassId> initClassIds, List<PersistentKlassId> hierClassIds, List<Long> compileOptions) {
        this.compileId = CompilationId.of(compileId);
        this.methodId = PersistentMethodId.of(methodId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.unmodifiableList(profileRefIds);
        this.loadedClassIds = Collections.unmodifiableList(loadClassIds);
        this.linkedClassIds = Collections.unmodifiableList(linkClassIds);
        this.initializedClassIds = Collections.unmodifiableList(initClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierClassIds);
        this.tierKind = PersistedTierKind.UNAVAILABLE;
        this.compileOptions = compileOptions.size() < 14 ? CompileOptions.buildCompileOptions(compileOptions, null, CompileOptionsVersion.V33) : CompileOptions.buildCompileOptions(compileOptions, null, CompileOptionsVersion.V59);
    }

    @ProfileVersion(value=64)
    public ProfiledTier2Compilation(int compileId, long methodId, List<PersistentMethodId> inlinedMethodIds, List<Integer> profileRefIds, List<PersistentKlassId> loadClassIds, List<PersistentKlassId> linkClassIds, List<PersistentKlassId> initClassIds, List<PersistentKlassId> hierClassIds, String tierKind, List<Long> compileOptions) {
        this.compileId = CompilationId.of(compileId);
        this.methodId = PersistentMethodId.of(methodId);
        this.inlinedMethodIds = Collections.unmodifiableList(inlinedMethodIds);
        this.profileRefIds = Collections.unmodifiableList(profileRefIds);
        this.loadedClassIds = Collections.unmodifiableList(loadClassIds);
        this.linkedClassIds = Collections.unmodifiableList(linkClassIds);
        this.initializedClassIds = Collections.unmodifiableList(initClassIds);
        this.hierarchyClassIds = Collections.unmodifiableList(hierClassIds);
        this.tierKind = PersistedTierKind.of(tierKind);
        this.compileOptions = compileOptions.size() < 14 ? CompileOptions.buildCompileOptions(compileOptions, null, CompileOptionsVersion.V33) : CompileOptions.buildCompileOptions(compileOptions, null, CompileOptionsVersion.V59);
    }

    public final String toString() {
        return "Tier2: " + this.compileId + " method: " + this.methodId + " inlinedMethods: " + this.inlinedMethodIds + " profiles: " + this.profileRefIds + " loadedClasses: " + this.loadedClassIds + " linkedClasses: " + this.linkedClassIds + " initedClasses: " + this.initializedClassIds + " hierarchies: " + this.hierarchyClassIds + " compileOptions: " + this.compileOptions;
    }
}

