/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.Gulp;
import com.azul.gulp.text.GulpText;
import com.azul.jvm.Opcode;
import com.azul.jvm.deopt.UncommonTrapId;
import com.azul.jvm.method.ByteCodeIndex;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.jvm.time.EpochTime;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.internals.ProfiledUncommonTrapEndLineMatcher;
import java.util.List;
import java.util.Objects;

@GulpText.LineMatcher(value=ProfiledUncommonTrapEndLineMatcher.class)
@ProfileRecord(value="UncommonTrapEnd")
public class ProfiledUncommonTrapEnd {
    @Gulp.Capture
    public EpochTime epochTime;
    public final UncommonTrapId id;
    public final int actionId;
    public final boolean entrant;
    public final List<Frame> frameRepacks;
    public final boolean stackTruncated;

    public ProfiledUncommonTrapEnd(int id, int actionId, boolean entrant, List<Frame> frameRepacks, boolean stackTruncated) {
        this.id = UncommonTrapId.of(id);
        this.actionId = actionId;
        this.entrant = entrant;
        this.frameRepacks = Objects.requireNonNull(frameRepacks);
        this.stackTruncated = stackTruncated;
    }

    public String toString() {
        return "ProfiledUncommonTrapEnd{epochTime=" + this.epochTime.nanos + ", id=" + this.id + ", actionId=" + this.actionId + ", entrant=" + this.entrant + ", stackTruncated=" + this.stackTruncated + "}";
    }

    public static class Frame {
        public final PersistentMethodId methodId;
        public final ByteCodeIndex bci;
        public final Opcode opcode;

        public Frame(PersistentMethodId methodId, ByteCodeIndex bci, Opcode opcode) {
            this.methodId = Objects.requireNonNull(methodId, "methodId");
            this.bci = Objects.requireNonNull(bci, "bci");
            this.opcode = Objects.requireNonNull(opcode, "opcode");
        }

        public String toString() {
            return this.methodId + "=" + this.bci + "(" + this.opcode + ")";
        }
    }
}

