/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog.internals;

import com.azul.gulp.Emitter;
import com.azul.jvm.klass.KlassKind;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderType;
import com.azul.jvm.method.PersistentMethodId;
import com.azul.zing.profilelog.ProfileHeader;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileLineMatcher;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public final class ProfileReflectiveLineMatcher<T>
extends ProfileLineMatcher<T> {
    private final Class<T> dataClass;
    private Constructor<T> ctor;

    public ProfileReflectiveLineMatcher(Class<T> dataClass) {
        super(dataClass);
        this.dataClass = dataClass;
        this.ctor = null;
    }

    private static <T> Constructor<T> getConstructor(Class<T> dataClass, ProfileHeader header) {
        Constructor<?>[] ctors = dataClass.getConstructors();
        if (ctors.length == 1) {
            Constructor<?> casted = ctors[0];
            return casted;
        }
        int targetVersion = header.version;
        Constructor<?> closestCtor = null;
        int closestVersion = 0;
        for (Constructor<?> curCtor : ctors) {
            int curVersion;
            ProfileVersion versionAnno = curCtor.getAnnotation(ProfileVersion.class);
            if (versionAnno == null || (curVersion = versionAnno.value()) > targetVersion || curVersion < closestVersion) continue;
            closestVersion = curVersion;
            closestCtor = curCtor;
        }
        if (closestCtor == null) {
            throw new IllegalStateException("No constructor found for version " + targetVersion + " for " + dataClass.getSimpleName());
        }
        Constructor<?> casted = closestCtor;
        return casted;
    }

    @Override
    protected void process(ProfileHeader version, ProfileLineMatcher.InputBuffer buffer, Emitter<T> emitter) throws Exception {
        if (this.ctor == null) {
            this.ctor = ProfileReflectiveLineMatcher.getConstructor(this.dataClass, version);
            this.ctor.setAccessible(true);
        }
        Type[] paramTypes = this.ctor.getGenericParameterTypes();
        Object[] params = new Object[paramTypes.length];
        try {
            for (int i = 0; i < paramTypes.length; ++i) {
                params[i] = ProfileReflectiveLineMatcher.get(buffer, paramTypes[i]);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("malformed record: " + this.dataClass, e);
        }
        try {
            emitter.fire(this.ctor.newInstance(params));
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to construct object for record: " + ProfileReflectiveLineMatcher.getRecordId(this.dataClass), e);
        }
    }

    private static Object get(ProfileLineMatcher.InputBuffer buffer, Type type) {
        if (type.equals(String.class)) {
            return buffer.readIdentifier();
        }
        if (type.equals(KlassLoaderType.class)) {
            return buffer.readClassLoaderType();
        }
        if (type.equals(KlassKind.class)) {
            return buffer.readClassKind();
        }
        if (type.equals(Integer.TYPE)) {
            return buffer.readInt();
        }
        if (type.equals(Integer.class)) {
            return buffer.readOptionalInteger();
        }
        if (type.equals(Long.TYPE)) {
            return buffer.readLong();
        }
        if (type.equals(Boolean.TYPE)) {
            return buffer.readBoolean();
        }
        if (ProfileReflectiveLineMatcher.isList(type)) {
            Class<?> elementType = ProfileReflectiveLineMatcher.getElementType(type);
            if (elementType.equals(Integer.class)) {
                return buffer.readIntList();
            }
            if (elementType.equals(Long.class)) {
                return buffer.readLongList();
            }
            if (elementType.equals(PersistentKlassId.class)) {
                return buffer.readPersistentKlassIdList();
            }
            if (elementType.equals(PersistentMethodId.class)) {
                return buffer.readPersistentMethodIdList();
            }
            throw new IllegalStateException("unsupported list element type: " + elementType);
        }
        throw new IllegalStateException("unsupported type: " + type);
    }

    private static boolean isList(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type;
        return paramType.getRawType().equals(List.class);
    }

    private static Class<?> getElementType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException();
        }
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[0];
    }
}

