/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog.internals;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.Normalizer;
import com.azul.gulp.text.Line;
import com.azul.gulp.text.RegexMatcher;
import com.azul.jvm.time.EpochTime;
import java.util.regex.Pattern;

public class ProfileTimestampLineNormalizer
implements Normalizer<Line> {
    private static final Pattern PATTERN = Pattern.compile("^\\s*(\\d+)\\s*\\|\\s*(.+)");
    @Gulp.Inject
    Emitter<EpochTime> timeEmitter;

    @Override
    public final Line normalize(Line line) throws Exception {
        RegexMatcher matcher = line.match(PATTERN);
        if (matcher.matches()) {
            long timestamp = matcher.nextLong();
            String remainder = matcher.nextString();
            this.timeEmitter.fire(EpochTime.fromNanos(timestamp));
            return new Line(line, remainder);
        }
        return line;
    }
}

