/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.readynow;

import java.util.Objects;

public class DirectiveKind {
    public final Kind kind;

    public DirectiveKind(String kind) {
        this.kind = this.decodeDirectiveKind(kind);
    }

    public String getStringKind() {
        return this.kind.stringValue();
    }

    public Kind decodeDirectiveKind(String kind) {
        switch (kind) {
            case "compile": {
                return Kind.DK_COMPILE;
            }
            case "compile_local_only": {
                return Kind.DK_COMPILE_LOCAL_ONLY;
            }
            case "compile_remote_only": {
                return Kind.DK_COMPILE_REMOTE_ONLY;
            }
        }
        return Kind.DK_UNKNOWN;
    }

    private static enum Kind {
        DK_COMPILE("compile"),
        DK_COMPILE_LOCAL_ONLY("compile_local_only"),
        DK_COMPILE_REMOTE_ONLY("compile_remote_only"),
        DK_UNKNOWN("unknown");

        private final String i;

        private Kind(String i) {
            this.i = i;
        }

        public String stringValue() {
            return this.i;
        }

        public static Kind fromString(String id) {
            for (Kind value : Kind.values()) {
                if (!Objects.equals(value.i, id)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown kind of directive " + id);
        }

        public String toString() {
            return this.i;
        }
    }
}

