/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.generational.AbortablePreClean;
import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.event.generational.ConcurrentMark;
import com.microsoft.gctoolkit.event.generational.ConcurrentPreClean;
import com.microsoft.gctoolkit.event.generational.ConcurrentReset;
import com.microsoft.gctoolkit.event.generational.ConcurrentSweep;
import com.microsoft.gctoolkit.event.generational.GenerationalGCEvent;
import com.microsoft.gctoolkit.event.generational.InitialMark;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.ICMSPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.SimplePatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Set;
import java.util.logging.Logger;

@Deprecated
public class CMSTenuredPoolParser
extends PreUnifiedGCLogParser
implements SimplePatterns,
ICMSPatterns {
    private static final Logger LOG = Logger.getLogger(CMSTenuredPoolParser.class.getName());
    private DateTimeStamp startOfPhase = null;
    private GCParseRule EndOfFile = new GCParseRule("END_OF_DATA_SENTINEL", "END_OF_DATA_SENTINEL");

    @Override
    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.CMS_PREUNIFIED);
    }

    @Override
    public String getName() {
        return ChannelName.CMS_TENURED_POOL_PARSER_OUTBOX.toString();
    }

    @Override
    protected void process(String line) {
        GCLogTrace trace = ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE.parse(line);
        if (trace != null) {
            this.abortPrecleanDueToTime(trace);
        } else {
            trace = CONCURRENT_PHASE_START_BLOCK.parse(line);
            if (trace != null) {
                this.startOfConcurrentPhase(trace);
            } else {
                trace = CONCURRENT_PHASE_END_BLOCK.parse(line);
                if (trace != null) {
                    this.endOfConcurrentPhase(trace);
                } else {
                    trace = PRECLEAN_REFERENCE.parse(line);
                    if (trace != null) {
                        this.endConcurrentPrecleanWithReferenceProcessing(trace);
                    } else {
                        trace = INITIAL_MARK.parse(line);
                        if (trace != null) {
                            this.initialMark(trace);
                        } else {
                            trace = REMARK_CLAUSE.parse(line);
                            if (trace != null) {
                                this.remark(trace, line);
                            } else {
                                trace = REMARK_REFERENCE_PROCESSING.parse(line);
                                if (trace != null) {
                                    this.remarkWithReferenceProcessing(trace, line);
                                } else {
                                    trace = SPLIT_REMARK.parse(line);
                                    if (trace != null) {
                                        this.startOfPhase = this.getClock();
                                    } else {
                                        trace = this.EndOfFile.parse(line);
                                        if (trace != null) {
                                            super.publish(ChannelName.CMS_TENURED_POOL_PARSER_OUTBOX, new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void initialMark(GCLogTrace trace) {
        InitialMark initialMark = new InitialMark(trace.getDateTimeStamp(), GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyWithMemoryPoolSizeSummary(7);
        MemoryPoolSummary heap = trace.getOccupancyWithMemoryPoolSizeSummary(11);
        initialMark.add(heap.minus(tenured), tenured, heap);
        this.publish(initialMark);
    }

    private void startOfConcurrentPhase(GCLogTrace trace) {
        this.startOfPhase = trace.getDateTimeStamp();
    }

    private void endOfConcurrentPhase(GCLogTrace trace) {
        DateTimeStamp endOfPhase = trace.getDateTimeStamp();
        this.endOfConcurrentPhase(trace, endOfPhase);
    }

    private void endConcurrentPrecleanWithReferenceProcessing(GCLogTrace trace) {
        try {
            this.publish(new ConcurrentPreClean(this.startOfPhase, trace.getDoubleGroup(14) - this.startOfPhase.getTimeStamp(), trace.getDoubleGroup(16), trace.getDoubleGroup(17)));
        }
        catch (Throwable t) {
            LOG.warning("concurrent phase choked on " + trace.toString());
        }
    }

    private void endOfConcurrentPhase(GCLogTrace trace, DateTimeStamp timeStamp) {
        String phase = trace.getGroup(6);
        double cpuTime = trace.getDoubleGroup(7);
        double wallTime = trace.getDoubleGroup(8);
        double duration = timeStamp.getTimeStamp() - this.startOfPhase.getTimeStamp();
        if ("mark".equals(phase)) {
            this.publish(new ConcurrentMark(this.startOfPhase, duration, cpuTime, wallTime));
        } else if ("preclean".equals(phase)) {
            this.publish(new ConcurrentPreClean(this.startOfPhase, duration, cpuTime, wallTime));
        } else if ("abortable-preclean".equals(phase)) {
            this.publish(new AbortablePreClean(this.startOfPhase, duration, cpuTime, wallTime, false));
        } else if ("sweep".equals(phase)) {
            this.publish(new ConcurrentSweep(this.startOfPhase, duration, cpuTime, wallTime));
        } else if ("reset".equals(phase)) {
            this.publish(new ConcurrentReset(this.startOfPhase, duration, cpuTime, wallTime));
        } else {
            LOG.warning("concurrent phase choked on " + trace.toString());
        }
    }

    private void abortPrecleanDueToTime(GCLogTrace trace) {
        try {
            double cpuTime = trace.getDoubleGroup(7);
            double wallClock = trace.getDoubleGroup(8);
            this.publish(new AbortablePreClean(this.startOfPhase, trace.getDateTimeStamp().getTimeStamp() - this.startOfPhase.getTimeStamp(), cpuTime, wallClock, true));
        }
        catch (Exception e) {
            LOG.warning("concurrent phase end choked on " + trace);
        }
    }

    private void remark(GCLogTrace trace, String line) {
        this.publish(this.extractRemark(trace, line));
    }

    private void remarkWithReferenceProcessing(GCLogTrace trace, String line) {
        CMSRemark remark = this.extractRemark(trace, line);
        remark.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        this.publish(remark);
    }

    private CMSRemark extractRemark(GCLogTrace trace, String line) {
        GCLogTrace prefix = GC_PREFIX_RULE.parse(line);
        GCCause gcCause = GCCause.CMS_FINAL_REMARK;
        if (prefix != null) {
            this.startOfPhase = this.getClock();
            gcCause = prefix.gcCause();
            if (gcCause == GCCause.UNKNOWN_GCCAUSE) {
                gcCause = GCCause.CMS_FINAL_REMARK;
            }
        }
        CMSRemark remark = new CMSRemark(this.startOfPhase, gcCause, trace.getDoubleGroup(trace.groupCount()));
        try {
            MemoryPoolSummary tenured = trace.getOccupancyWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = trace.getOccupancyWithMemoryPoolSizeSummary(5);
            remark.add(heap.minus(tenured), tenured, heap);
            this.recordRescanStepTimes(remark, line);
            remark.add(this.extractPrintReferenceGC(line));
        }
        catch (Exception e) {
            LOG.warning("Unable to properly extract data from " + trace);
        }
        return remark;
    }

    private void publish(GenerationalGCEvent event) {
        super.publish(ChannelName.CMS_TENURED_POOL_PARSER_OUTBOX, event);
    }

    @Override
    public boolean accepts(Diary diary) {
        return diary.isCMS() && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }
}

