/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JHiccupTrace {
    private static final String TIME = "(\\d+(?:,|.)\\d+)";
    public static final Pattern JHICCUP_LOG_ENTRY = Pattern.compile("(\\d+(?:,|.)\\d+),(\\d+(?:,|.)\\d+),(\\d+(?:,|.)\\d+),HIST");
    private static final String US_FORMAT_SEPARATOR = ".";
    private static final String EUROPEAN_FORMAT_SEPARATOR = ",";
    private final Matcher trace;

    public static JHiccupTrace toTrace(String line) {
        Matcher m = JHICCUP_LOG_ENTRY.matcher(line);
        return m == null ? null : new JHiccupTrace(m);
    }

    protected JHiccupTrace(Matcher matcher) {
        this.trace = matcher;
    }

    public double getTimeStamp() {
        return this.getDoubleGroup(1);
    }

    public double getInterval() {
        return this.getDoubleGroup(2);
    }

    public double getDuration() {
        return this.getDoubleGroup(3);
    }

    public double getDoubleGroup(int index) {
        return this.convertToDouble(this.trace.group(index));
    }

    private double convertToDouble(String value) {
        return Double.parseDouble(value.replaceAll(EUROPEAN_FORMAT_SEPARATOR, US_FORMAT_SEPARATOR));
    }

    public String getGroup(int index) {
        return this.trace.group(index);
    }
}

