/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.AgentBase;
import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.FileUtils;
import com.azul.crs.javaagent.client.JDKAccessFactory;
import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.Version;
import com.azul.crs.javaagent.client.agent.ChainContext;
import com.azul.crs.javaagent.client.agent.ChainTransformer;
import com.azul.crs.javaagent.client.agent.MainMethodDetection;
import com.azul.crs.javaagent.client.agent.MainMethodDetectionInterface;
import com.azul.crs.javaagent.client.classLoad.ClassLoadReportingTransformer;
import com.azul.crs.javaagent.client.firstCall.FirstCallReportingTransformer;
import com.azul.crs.javaagent.client.service.JarLoadReporter;
import com.azul.crs.javaagent.client.service.JarLoadReporterInterface;
import com.azul.crs.javaagent.client.service.MessageQueueService;
import com.azul.crs.javaagent.jar.ZipTools;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;

public final class Agent002
extends AgentBase {
    private static final String accessorArgumentPrefix = "accessor=";
    private static final String BUNDLED_ACCESSOR_NAME = "accessor-jar";
    private final Instrumentation instrumentation;
    private final JDKAccessor jdkAccessor;
    private JarLoadReporterInterface jarLoadReporter;
    private MainMethodDetectionInterface mainMethodDetector;
    private MessageQueueService messageQueueService;
    private static Agent002 instance;
    private long delayInitiation;
    private final Object agentDelayInitiationLock = new Object();

    private Agent002(Instrumentation inst, JDKAccessor jdkAccessor) {
        this.instrumentation = inst;
        this.jdkAccessor = jdkAccessor;
    }

    @Override
    public String agentType() {
        return "java";
    }

    public static void premain(String args, Instrumentation inst) {
        if (!Agent002.hasAccess()) {
            String limitedAccessErrorMsg = "Unable to initialize Azul IC Agent: not enough permissions - check access to the java.management module and see the documentation for details.";
            System.out.println(limitedAccessErrorMsg);
            return;
        }
        Logger logger = Logger.getLogger(Agent002.class);
        JDKAccessor jdkAccessor = null;
        try {
            if (instance != null) {
                logger.warning("Azul IC Agent already initialized.", new Object[0]);
                return;
            }
            try {
                jdkAccessor = JDKAccessFactory.getAccessor(inst, Agent002::prepareAccessorJar);
            }
            catch (RuntimeException e) {
                System.err.println("WARNING: [CRS agent] failed to get accessor: " + e.getMessage());
                if (Boolean.getBoolean(System.getProperty("com.azul.crs.javaagent.".substring(0, 13) + "force.trace.logging", "false"))) {
                    e.printStackTrace(System.err);
                }
                System.err.println("WARNING: [CRS agent] continues without JDK Accessor.");
            }
            if (args != null && args.startsWith(accessorArgumentPrefix)) {
                int comma = args.indexOf(44);
                args = comma > 0 ? args.substring(comma + 1) : "";
                System.err.println("WARNING: \"accessor\" parameter is deprecated and it has no effect anymore.");
            }
        }
        catch (Throwable th) {
            System.err.println("ERROR: [CRS agent] failed to initialize JDKAccessor: " + th.getMessage());
        }
        try {
            instance = new Agent002(inst, jdkAccessor);
            instance.init(args);
        }
        catch (Throwable th) {
            logger.error("%s", th.getMessage());
            logger.error("Failed to initialize agent with: %s", th);
            logger.debug("cause: %s", th);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String prepareAccessorJar() {
        try (InputStream source = Agent002.class.getResourceAsStream(BUNDLED_ACCESSOR_NAME);){
            if (source == null) {
                throw new RuntimeException("Cannot find the accessor in a-agent.jar!");
            }
            Path tmpAccessorJarName = FileUtils.createTempFile("tmp_", ".jar");
            Files.copy(source, tmpAccessorJarName, StandardCopyOption.REPLACE_EXISTING);
            tmpAccessorJarName.toFile().deleteOnExit();
            String string = tmpAccessorJarName.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create accessor.jar in temporary folder.", e);
        }
    }

    private static boolean hasAccess() {
        try {
            ManagementFactory.getRuntimeMXBean();
        }
        catch (Throwable e) {
            System.out.println("[Azul IC Agent] An exception occurred while checking the access to module java.management: " + e.getMessage());
            return false;
        }
        return true;
    }

    void init(String args) {
        Options.mode.set("on", Options.Origin.ERGONOMIC);
        super.init(args, this::isSupportedOption);
        ChainTransformer transformer = null;
        try {
            Version version = new Version();
            this.logger.info("%s %s (%s) started with args='%s' and %s accessor.", "Azul IC Agent", version.clientVersion(), version.clientRevision(), args, this.jdkAccessor == null ? "disabled" : "enabled");
            this.messageQueueService = MessageQueueService.builder().withReferenceFactory(this.referenceFactory).withNotifyJarLoad(Options.notifyJarLoad.isYes()).withNotifyClassLoad(Options.notifyClassLoad.isYes()).withNotifyFirstCall(Options.notifyFirstCall.isYes()).build();
            transformer = ChainTransformer.getInstance(ChainContext.contextFactory(this.instrumentation), FirstCallReportingTransformer.getInstance(this.messageQueueService), ClassLoadReportingTransformer.getInstance(this.messageQueueService));
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize: %s", e);
        }
        this.delayInitiation = Options.delayInitiation.getLong();
        this.finishInit(this.jdkAccessor);
        if (transformer != null) {
            this.instrumentation.addTransformer(transformer);
        }
    }

    @Override
    public boolean isSupportedOption(Options option) {
        switch (option) {
            case forceSyncTimeout: 
            case lifetimejfr: 
            case sendJVMLogs: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean delayInitiation() {
        try {
            Object object = this.agentDelayInitiationLock;
            synchronized (object) {
                if (this.delayInitiation > 0L && !Client.isVMShutdownInitiated()) {
                    this.agentDelayInitiationLock.wait(this.delayInitiation);
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.info("Received interrupt for delay of initiation, shutdown has been started.", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    boolean startupSpecific0() {
        if (!this.delayInitiation()) {
            return false;
        }
        if (this.jdkAccessor == null) {
            this.logger.debug("no access to protected JDK functionality. using generic zip central directory access method", new Object[0]);
        } else {
            this.logger.debug("obtained access to protected JDK functionality. using %s zip central directory access method", this.jdkAccessor.supportsGetZipCentralDirectory() ? "optimized" : "generic");
            ZipTools.setJdkAccessor(this.jdkAccessor);
        }
        return true;
    }

    @Override
    void startupSpecific2() throws IOException {
        this.jarLoadReporter = new JarLoadReporter(this.jarLoadService);
        this.mainMethodDetector = new MainMethodDetection(this.eventConsumer);
        if (this.messageQueueService != null) {
            this.messageQueueService.init(this.firstCallMonitor, this.classLoadMonitor, this.jarLoadReporter, this.mainMethodDetector);
            this.messageQueueService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void teardownSpecific1(Utils.Deadline deadline) throws InterruptedException {
        Object object = this.agentDelayInitiationLock;
        synchronized (object) {
            Client.setVMShutdownInitiated(deadline);
            this.agentDelayInitiationLock.notify();
        }
    }

    @Override
    void teardownSpecific2(Utils.Deadline deadline) {
        this.logger.debug("drain load class event queue", new Object[0]);
        this.stopServices(deadline, this.messageQueueService);
    }

    @Override
    void terminateBecauseOOMSpecific() {
        try {
            this.teardownSpecific1(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminateServices(this.messageQueueService);
    }
}

