/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.CRSException;
import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.ClientProperties;
import com.azul.crs.javaagent.client.Inventory;
import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Result;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.Version;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.CRSLogService;
import com.azul.crs.javaagent.client.service.ClassLoadMonitor;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.client.service.FirstCallMonitor;
import com.azul.crs.javaagent.client.service.HeartbeatService;
import com.azul.crs.javaagent.client.service.JarLoadService;
import com.azul.crs.javaagent.runtime.utils.TempFilesFactory;
import com.azul.crs.javaagent.util.logging.Logger;
import com.azul.crs.javaagent.util.logging.LoggingHelper;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;

abstract class AgentBase {
    protected static final String AGENT_NAME = "Azul IC Agent";
    private static final String SM_RELATED_ERR_MSG = "Unable to initialize Azul IC Agent: not enough permissions - please check security settings and see the documentation for details.";
    JarLoadService jarLoadService;
    ClassLoadMonitor classLoadMonitor;
    FirstCallMonitor firstCallMonitor;
    HeartbeatService heartbeatService;
    private boolean syncFailedNotSent = true;
    Client client;
    VmEventConsumer eventConsumer;
    private Thread agentStartupThread;
    private final Lock agentStartupThreadLock = new ReentrantLock();
    private long delayTermination;
    final Logger logger;
    final CRSLogService crslogService = new CRSLogService();
    ReferenceFactory referenceFactory;
    private static volatile Utils.Deadline deadline;
    private AtomicBoolean farewellStarted = new AtomicBoolean(false);

    AgentBase() {
        this.logger = Logger.getLogger(this.getClass());
        Logger.addOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (!Options.sendCRSLogs.isYes()) {
                    return;
                }
                AgentBase.this.crslogService.notifyCRSLogEntry(b, off, len);
            }
        });
    }

    public abstract String agentType();

    public String fullName() {
        Version version = new Version();
        return String.format("%s %s (%s) (%s)", AGENT_NAME, version.clientVersion(), version.clientRevision(), this.agentType());
    }

    private String dumpProperty(String s) {
        return String.format("\n  %s: %s", s, System.getProperty(s));
    }

    private void dumpProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("system properties:");
        sb.append(this.dumpProperty("java.vm.version"));
        sb.append(this.dumpProperty("java.vm.name"));
        sb.append(this.dumpProperty("java.vm.vendor"));
        sb.append(this.dumpProperty("java.vm.info"));
        sb.append(this.dumpProperty("java.vm.specification.name"));
        sb.append(this.dumpProperty("java.vm.specification.vendor"));
        sb.append(this.dumpProperty("java.vm.specification.version"));
        Tweaks.dump(p -> sb.append(this.dumpProperty((String)p)));
        this.logger.info(sb.toString(), new Object[0]);
    }

    void init(String args, Predicate<Options> isSupportedOption) {
        try {
            long agentStartTimestamp = Utils.currentTimeCount();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.teardownAgent(agentStartTimestamp)));
            Options.read(args);
            Options.checkIntegrity(isSupportedOption);
            Options.dump(this.fullName(), isSupportedOption);
            this.dumpProperties();
            FeatureFlagsConfiguration.initialize(Options.notifyJarLoad.isYes(), Options.notifyClassLoad.isYes(), Options.notifyFirstCall.isYes(), Options.sendClassMethods.isYes());
            this.referenceFactory = ReferenceFactory.getReferenceFactoryFactory(Options.memorySafeguards.isYes()).apply(this::terminateBecauseOOM);
        }
        catch (IllegalStateException ignored) {
            return;
        }
        catch (SecurityException ex) {
            throw new SecurityException(SM_RELATED_ERR_MSG);
        }
        this.addExtraLogFileToLogger();
    }

    private void addExtraLogFileToLogger() {
        String optionExtraLogFile = Options.extraLogFile.get();
        if (optionExtraLogFile != null) {
            try {
                Logger.addOutputStream(new FileOutputStream(optionExtraLogFile));
            }
            catch (FileNotFoundException e) {
                this.logger.warning("Can not open extra log file: " + optionExtraLogFile, new Object[0]);
            }
        }
    }

    void finishInit(JDKAccessor jdkAccessor) {
        PerformanceMetrics.init(jdkAccessor);
        this.delayTermination = Options.delayTermination.getLong();
        System.setProperty("com.azul.crs.javaagent.instance.options.delayTermination", Long.toString(this.delayTermination));
        if ("on".equals(Options.mode.get())) {
            this.activateAgent(null);
        } else if (!"auto".equals(Options.mode.get())) {
            // empty if block
        }
    }

    private void activateAgent(String mainMethod) {
        block8: {
            if (this.hardstop()) {
                return;
            }
            this.agentStartupThreadLock.lock();
            try {
                if (this.agentStartupThread == null) {
                    this.agentStartupThread = new Thread(this.referenceFactory.getThreadGroup(), () -> this.startupAgent(mainMethod), "CRSStartThread");
                    this.agentStartupThread.setDaemon(true);
                    this.agentStartupThread.start();
                    break block8;
                }
                if (mainMethod == null) break block8;
                try {
                    this.agentStartupThread.join();
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    this.agentStartupThreadLock.unlock();
                    return;
                }
                this.postMainMethodName(mainMethod);
            }
            finally {
                this.agentStartupThreadLock.unlock();
            }
        }
    }

    void startupAgent(String mainMethod) {
        long startTime = Utils.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
        try {
            if (!this.startupSpecific0()) {
                return;
            }
            ClientProperties clientProperties = new ClientProperties(Options.getClientProps(), this.delayTermination);
            clientProperties.validate();
            this.client = new Client(clientProperties.getProperties(), new Client.ClientListener(){
                private boolean connectionEstablished = false;

                @Override
                public void authenticated() {
                    if (AgentBase.this.client.getVmId() != null) {
                        AgentBase.this.logger.info("Agent authenticated: vmId=%s", AgentBase.this.client.getVmId());
                        if (AgentBase.this.logger.isEnabled(Logger.Level.DEBUG)) {
                            AgentBase.this.logger.debug(" VM uptime %dms", ManagementFactory.getRuntimeMXBean().getUptime());
                        }
                        if (!this.connectionEstablished) {
                            AgentBase.this.client.connectionEstablished();
                        }
                        this.connectionEstablished = true;
                    } else {
                        AgentBase.this.disableCRS("Backend malfunction, invalid vmId received", null);
                    }
                }

                @Override
                public void syncFailed(Result<String[]> reason) {
                    IOException e;
                    if (AgentBase.this.syncFailedNotSent) {
                        AgentBase.this.logger.error("Data synchronization to the CRS cloud has failed: %s", reason.errorString());
                        AgentBase.this.syncFailedNotSent = false;
                    } else {
                        AgentBase.this.logger.debug("Data synchronization to the CRS cloud has failed: %s", reason.errorString());
                    }
                    if (reason.hasException() && (e = reason.getException()) instanceof CRSException && ((CRSException)e).isProtocolFailure()) {
                        AgentBase.this.disableCRS("Protocol failure", e);
                    }
                }
            }, this.referenceFactory);
            if (this.logger.isEnabled(Logger.Level.DEBUG)) {
                this.logger.debug("%s initialized. VM start timestamp %d, VM uptime %dms", AGENT_NAME, startTime, ManagementFactory.getRuntimeMXBean().getUptime());
            }
            this.eventConsumer = this.client.getVmEventConsumer();
            this.postVMStart(startTime, mainMethod);
            this.heartbeatService = HeartbeatService.getInstance(this.referenceFactory, this.eventConsumer);
            this.crslogService.setEventConsumer(this.eventConsumer);
            this.classLoadMonitor = new ClassLoadMonitor(this.eventConsumer);
            this.firstCallMonitor = new FirstCallMonitor(this.eventConsumer);
            this.jarLoadService = JarLoadService.getInstance(this.eventConsumer, this.referenceFactory);
            this.startServices(this.crslogService, this.heartbeatService, this.jarLoadService);
            this.startupSpecific1(startTime);
            this.client.startup();
            this.postSystemInformation();
            this.startupSpecific2();
        }
        catch (Throwable th) {
            this.disableCRS("CRS failed to start: %s", th);
        }
    }

    public boolean isSupportedOption(Options option) {
        return true;
    }

    boolean startupSpecific0() {
        return true;
    }

    void startupSpecific1(long startTime) {
    }

    void startupSpecific2() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownAgent(long agentStartTimestamp) {
        try {
            Utils.Deadline shutdownDeadline;
            deadline = shutdownDeadline = Utils.Deadline.in(this.delayTermination, TimeUnit.MILLISECONDS);
            long shutdownStartTime = Utils.currentTimeCount();
            this.logger.trace("checking if startup is complete and waiting for it to finish (%d ms)", this.delayTermination);
            this.teardownSpecific1(deadline);
            if (deadline.applyIfNotExpired(ms -> this.agentStartupThreadLock.tryLock(ms, TimeUnit.MILLISECONDS)).orElse(false).booleanValue()) {
                try {
                    if (this.agentStartupThread != null) {
                        deadline.runIfNotExpired(ms -> this.agentStartupThread.join(ms));
                    }
                }
                finally {
                    this.agentStartupThreadLock.unlock();
                }
            }
            this.teardownSpecific2(deadline);
            this.stopServices(shutdownDeadline, this.jarLoadService, this.crslogService, this.heartbeatService);
            LoggingHelper.logStatistics(this.logger, Logger.Level.INFO);
            if (this.client != null) {
                Map perfMonData = PerformanceMetrics.logPreShutdown(Utils.elapsedTimeMillis(shutdownStartTime));
                this.postVMShutdown(perfMonData);
                this.client.shutdown(shutdownDeadline);
                if (this.client.getVmId() != null) {
                    PerformanceMetrics.logShutdown(Utils.elapsedTimeMillis(shutdownStartTime));
                    PerformanceMetrics.report();
                    this.logger.info("Agent terminated: vmId=%s, runningTime=%d", this.client.getVmId(), Utils.elapsedTimeMillis(agentStartTimestamp));
                } else {
                    this.logger.info("Agent shut down during startup. Data is discarded. runningTime=%d", Utils.elapsedTimeMillis(agentStartTimestamp));
                }
            }
            if (deadline.hasExpired()) {
                this.logger.warning("Agent exceeded delayTermination timeout. Some data might be unsent. Consider increasing delayTermination timeout.", new Object[0]);
            } else {
                this.logger.debug("Remaining delayTermination time: %dms", deadline.remainder(TimeUnit.MILLISECONDS));
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.logger.error("%s shutdown was interrupted. Data is discarded.", AGENT_NAME);
        }
        catch (Throwable th) {
            this.logger.error("Internal error or unexpected problem occurred - %s is disabled.", AGENT_NAME);
            th.printStackTrace(System.err);
        }
        finally {
            try {
                TempFilesFactory.shutdown();
                this.referenceFactory.getThreadGroup().interrupt();
            }
            catch (Throwable e) {}
        }
        this.referenceFactory.onShutdown();
    }

    void teardownSpecific1(Utils.Deadline deadline) throws InterruptedException {
    }

    void teardownSpecific2(Utils.Deadline deadline) {
    }

    private void postVMStart(long startTime, String mainMethod) throws Exception {
        Map<String, Object> inventory = new Inventory().populate(this.client.getEnvFilter(), this.client.getSysPropsFilter()).mainMethod(mainMethod).toMap();
        this.logger.trace("Post VM start to CRS service", new Object[0]);
        this.eventConsumer.consumeVMStart(inventory, Options.dumpCrsArgs(), startTime);
    }

    private void postMainMethodName(String mainMethod) {
        Map<String, Object> inventory = new Inventory().mainMethod(mainMethod).toMap();
        this.eventConsumer.patchInventory(inventory);
    }

    private void postSystemInformation() {
        Map<String, Object> inventory = new Inventory().systemInformation().toMap();
        this.eventConsumer.patchInventory(inventory);
    }

    private void postVMShutdown(Map perfMonData) {
        this.logger.trace("Post VM shutdown to CRS service", new Object[0]);
        ArrayList<VMEvent> trailingEvents = new ArrayList<VMEvent>();
        trailingEvents.add(new VMEvent().eventType(VMEvent.Type.VM_PERFORMANCE_METRICS).randomEventId().eventTime(Utils.currentTimeMillis()).eventPayload(perfMonData));
        this.eventConsumer.consumeVMShutdown(trailingEvents);
    }

    private void postVMDisconnected() {
        if (!Tweaks.VM_DISCONNECT_ALLOWED) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("cause", "OOM_ERROR");
        map.put("details", String.format("Agent terminated with OOM error: %s", this.referenceFactory.stats()));
        VMEvent event = new VMEvent().eventType(VMEvent.Type.VM_DISCONNECTED).randomEventId().eventTime(Utils.currentTimeMillis()).eventPayload(map);
        this.eventConsumer.consumeVMDisconnectedSynchronously(event);
    }

    void startServices(ClientService ... services) {
        for (ClientService service : services) {
            if (service == null) continue;
            try {
                service.start();
            }
            catch (Exception ex) {
                this.logger.error("Agent failed to start " + service.serviceName() + ". Data is discarded", new Object[0]);
                ex.printStackTrace(System.err);
            }
        }
    }

    void stopServices(Utils.Deadline shutdownDeadline, ClientService ... services) {
        for (ClientService service : services) {
            if (service == null) continue;
            try {
                service.stop(shutdownDeadline);
            }
            catch (Exception ex) {
                this.referenceFactory.notifyWithException(ex);
                this.logger.error("Agent failed to stop " + service.serviceName() + ". Data is discarded", new Object[0]);
                ex.printStackTrace(System.err);
            }
        }
    }

    void terminateServices(ClientService ... services) {
        for (ClientService service : services) {
            if (service == null) continue;
            try {
                service.terminate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    synchronized void shutdownAgent() {
        if (this.jarLoadService != null) {
            this.jarLoadService.cancel();
        }
        if (this.client != null) {
            this.client.cancel();
        }
    }

    private void disableCRS(String cause, Throwable thr) {
        this.shutdownAgent();
        if (thr == null) {
            this.logger.error(cause, new Object[0]);
        } else {
            this.logger.error(cause, thr);
            if (thr.getCause() != null) {
                this.logger.trace("caused by: %s", thr.getCause());
            }
        }
    }

    void mainMethodDetected(String mainMethod) {
        if (!mainMethod.startsWith("com/sun/tools")) {
            this.activateAgent(mainMethod);
        } else {
            this.shutdownAgent();
        }
    }

    boolean hardstop() {
        Utils.Deadline d = deadline;
        return d != null && d.hasExpired();
    }

    abstract void terminateBecauseOOMSpecific();

    private void terminateBecauseOOM() {
        if (this.farewellStarted.compareAndSet(false, true)) {
            this.postVMDisconnected();
            this.logger.error("Agent terminated with OOM error: maxMemory=" + Runtime.getRuntime().maxMemory() + ", freeMemory=" + Runtime.getRuntime().freeMemory() + ", totalMemory=" + Runtime.getRuntime().totalMemory(), new Object[0]);
            this.terminateBecauseOOMSpecific();
            this.terminateServices(this.jarLoadService, this.crslogService, this.heartbeatService);
            this.shutdownAgent();
        }
    }

    static enum VMCRSCapability {
        POST_CLASS_LOAD_EVENTS,
        POST_FIRST_CALL_EVENTS,
        POST_NOTIFY_TO_JAVA_CALLS,
        POST_VM_LOG_EVENTS,
        POST_JAR_LOAD_EVENTS,
        POST_VM_TOOLING_EVENT;

    }
}

