/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;

public final class AgentLauncher {
    private static int getVersion() {
        try {
            String specVersion = System.getProperty("java.specification.version");
            if (specVersion.startsWith("1.")) {
                specVersion = specVersion.substring(2, 3);
            }
            return Integer.parseInt(specVersion);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    private static void tryToPutAgentToBootclasspath(Instrumentation inst) {
        try {
            if (AgentLauncher.class.getClassLoader() != null) {
                JarFile jar;
                URLConnection c1 = AgentLauncher.class.getProtectionDomain().getCodeSource().getLocation().openConnection();
                if (c1 instanceof JarURLConnection) {
                    jar = ((JarURLConnection)c1).getJarFile();
                } else {
                    URL url = new URL("jar:" + AgentLauncher.class.getProtectionDomain().getCodeSource().getLocation().toString() + "!/");
                    jar = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                inst.appendToBootstrapClassLoaderSearch(jar);
            }
        }
        catch (Exception e) {
            System.err.println("[WARNING] Azul IC Agent: Failed to append a-agent.jar to boot classpath: " + e.getMessage() + (e.getCause() != null ? "; " + e.getCause().getMessage() : ""));
        }
    }

    public static void premain(String args, Instrumentation inst) {
        if (AgentLauncher.getVersion() < 8) {
            System.err.println("Azul IC Agent requires 8+ java runtime to run");
        } else {
            try {
                AgentLauncher.tryToPutAgentToBootclasspath(inst);
                Class<?> agentClass = Class.forName("com.azul.crs.javaagent.client.Agent002");
                Method premain = agentClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
                premain.invoke(null, args, inst);
            }
            catch (Exception e) {
                System.err.println("[ERROR] Azul IC Agent: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
    }
}

