/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.Result;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;

public class CRSException
extends IOException {
    public static final int REASON_NO_ENDPOINT = -1;
    public static final int AUTHENTICATION_FAILURE = -2;
    public static final int REASON_GENERIC = -3;
    public static final int REASON_INTERNAL_ERROR = -4;
    public static final int REASON_UNSUPPORTED_VERSION = -5;
    public static final int REASON_ONLY_HTTPS_SUPPORTED = -6;
    private static final String MESSAGE_NO_ENDPOINT = "No CRS endpoint found.\nPlease specify via command line arguments or verify if your DNS has CRS record provisioned";
    private static final String MESSAGE_ENDPOINT_AUTHENTICATION_FAILED = "CRS endpoint authentication error.\nPlease ensure you have a proper endpoint address specified in the command line or your DNS settings.";
    private static final String MESSAGE_ENDPOINT_ADDRESS = "\n API endpoint address as configured now: ";
    private static final String MESSAGE_UNSUPPORTED_VERSION = "\n Unsupported version";
    private static final String MESSAGE_ONLY_HTTPS_SUPPORTED = "\n Azul java agent supports HTTPS protocol only in api.url parameter.";
    private final int reason;
    private final Result result;
    private final Client client;

    public CRSException(int reason) {
        this(null, reason, null, null);
    }

    public CRSException(int reason, String message, Throwable cause) {
        super(message, cause);
        this.client = null;
        this.reason = reason;
        this.result = null;
    }

    public CRSException(Client client, int reason, String message, Result result) {
        super(message);
        this.client = client;
        this.reason = reason;
        this.result = result;
        if (result != null && result.hasException()) {
            this.initCause(result.getException());
        }
    }

    public boolean isProtocolFailure() {
        return this.reason == -5;
    }

    @Override
    public String toString() {
        StringBuilder message = new StringBuilder();
        switch (this.reason) {
            case -1: {
                message.append(MESSAGE_NO_ENDPOINT);
                break;
            }
            case -5: {
                message.append(MESSAGE_UNSUPPORTED_VERSION);
                break;
            }
            case -6: {
                message.append(MESSAGE_ONLY_HTTPS_SUPPORTED);
                break;
            }
            case -2: {
                if (this.getCause() != null) {
                    if (this.getCause() instanceof SSLHandshakeException) {
                        message.append(MESSAGE_ENDPOINT_AUTHENTICATION_FAILED);
                    } else if (this.getCause() instanceof UnknownHostException) {
                        message.append(MESSAGE_NO_ENDPOINT);
                    } else {
                        message.append(this.getMessage()).append(this.result.errorString());
                    }
                } else {
                    message.append(this.getMessage());
                    if (this.result != null) {
                        message.append(this.result.errorString());
                    }
                }
                if (this.client == null || this.client.getRestAPI() == null) break;
                message.append(MESSAGE_ENDPOINT_ADDRESS).append(this.client.getRestAPI());
                break;
            }
            default: {
                message = new StringBuilder(this.getMessage());
                if (this.getCause() == null) break;
                message.append("\nCaused by: ").append(this.getCause().toString());
            }
        }
        return message.toString();
    }
}

