/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.CRSException;
import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.ConnectionManager;
import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.util.DnsDetect;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.util.Map;

public class ClientProperties {
    private static final String DEFAULT_API_MAILBOX = "default";
    private final Map<Client.ClientProp, Object> properties;

    public ClientProperties(Map<Client.ClientProp, Object> clientProps, long delayTermination) throws CRSException {
        boolean hasEndpointConfig;
        this.properties = clientProps;
        this.properties.put(Client.ClientProp.CONNECTION_MANAGER, Options.connectionManager.get());
        this.properties.put(Client.ClientProp.VM_SHUTDOWN_DELAY, delayTermination);
        if (this.properties.get((Object)Client.ClientProp.API_MAILBOX) == null) {
            this.properties.put(Client.ClientProp.API_MAILBOX, DEFAULT_API_MAILBOX);
        }
        boolean bl = hasEndpointConfig = this.properties.get((Object)Client.ClientProp.API_URL) != null;
        if (!hasEndpointConfig) {
            try {
                DnsDetect detector = new DnsDetect(Options.stackRecordId.get());
                Logger.getLogger(ConnectionManager.class).info("querying DNS record%s", detector.getRecordNamePostfix().length() > 0 ? " (postfix " + detector.getRecordNamePostfix() + ")" : "");
                String endpoint = detector.queryEndpoint();
                if (endpoint == null) {
                    throw new CRSException(-1);
                }
                this.properties.put(Client.ClientProp.API_URL, "https://" + endpoint);
            }
            catch (IOException ex) {
                throw new CRSException(-1, "DNS query error and not enough configuration supplied", ex);
            }
        } else {
            String apiUrl = (String)this.properties.get((Object)Client.ClientProp.API_URL);
            if (!apiUrl.startsWith("https://")) {
                throw new CRSException(-6);
            }
            if (apiUrl.endsWith("/")) {
                this.properties.put(Client.ClientProp.API_URL, this.removeTrailingSlashes(apiUrl));
            }
        }
    }

    public void validate() {
        for (Client.ClientProp p : Client.ClientProp.values()) {
            if (!p.isMandatory() || this.properties.get((Object)p) != null) continue;
            throw new IllegalArgumentException("Invalid CRS properties file: missing value for " + p.value());
        }
    }

    private String removeTrailingSlashes(String apiUrl) {
        for (int i = apiUrl.length() - 1; i >= 0; --i) {
            if (apiUrl.charAt(i) == '/') continue;
            return apiUrl.substring(0, i + 1);
        }
        return apiUrl;
    }

    public Map<Client.ClientProp, Object> getProperties() {
        return this.properties;
    }
}

