/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.CRSException;
import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.InterfaceConnectionManager;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Response;
import com.azul.crs.javaagent.client.Result;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.models.Payload;
import com.azul.crs.javaagent.client.models.ServerRequest;
import com.azul.crs.javaagent.client.models.VMArtifactChunk;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.service.ClientService;
import com.azul.crs.javaagent.client.service.DataWriter;
import com.azul.crs.javaagent.client.service.ServerRequestsService;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ConnectionManager
implements InterfaceConnectionManager {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String AUTH_TOKEN_RESOURCE = "/crs/auth/rt/token";
    private static final String EVENT_RESOURCE = "/crs/instance/{vmId}";
    private static final String ARTIFACT_CHUNK_RESOURCE = "/crs/artifact/chunk";
    private static final String MEDIA_TYPE_TEXT_PLAIN = "text/plain";
    private static final String MEDIA_TYPE_JSON = "application/json";
    private static final String MEDIA_TYPE_BINARY = "application/octet-stream";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String HEADER_CONNECTION = "Connection";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_EVENT_BATCH_SEND_TIME = "x-agent-batch-send-time";
    private static final String HEADER_EVENT_BATCH_ID = "x-agent-batch-id";
    private static final String HEADER_API_KEY = "x-api-key";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_PATCH = "PATCH";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String AGENT_VERSION = "x-agent-version";
    private final Logger logger = Logger.getLogger(ConnectionManager.class);
    private final String restAPI;
    private final String mailbox;
    private final InterfaceConnectionManager.ConnectionListener listener;
    private final HttpConnectionPinger connectionPinger;
    private final ReferenceFactory referenceFactory;
    private static final long PING_CONNECTION_EVERY_MS = 4000L;
    private static final long TOKEN_REFRESH_TIMEOUT_MS = 300000L;
    public static final int HTTP_STATUS_UNAUTHORIZED = 401;
    public static final int HTTP_STATUS_UPGRADE_REQUIRED = 426;
    private final Client client;
    private final String keystore;
    private final String keyStorePasswd;
    private final String KEY_STORE_DEFAULT = "crs.jks";
    private final String KEY_STORE_PASSWORD_DEFAULT = "crscrs";
    private final String apiKey;
    private String runtimeToken;
    private long nextRuntimeTokenRefreshTimeCount;
    private String vmId;
    private boolean unrecoverableError;
    private SSLSocketFactory sslSocketFactory;
    private static final ConnectionConsumer NONE = new ConnectionConsumer(){

        @Override
        public void consume(HttpsURLConnection con) throws IOException {
        }
    };

    ConnectionManager(ReferenceFactory referenceFactory, Map<Client.ClientProp, Object> props, Client client, InterfaceConnectionManager.ConnectionListener listener) {
        this.client = client;
        this.listener = listener;
        this.referenceFactory = referenceFactory;
        this.connectionPinger = new HttpConnectionPinger(referenceFactory, 4000L, TimeUnit.MILLISECONDS);
        this.restAPI = (String)props.get((Object)Client.ClientProp.API_URL);
        this.mailbox = (String)props.get((Object)Client.ClientProp.API_MAILBOX);
        this.keystore = (String)props.get((Object)Client.ClientProp.KS);
        this.keyStorePasswd = props.get((Object)Client.ClientProp.KSP) != null ? (String)props.get((Object)Client.ClientProp.KSP) : "crscrs";
        this.apiKey = (String)props.get((Object)Client.ClientProp.ACCESS_KEY);
        this.logger.info("Using CRS endpoint configuration\n   API url = %s\n   mailbox = %s", this.restAPI, this.mailbox);
        if (this.keystore != null) {
            this.logger.info("   auth override keystore = %s", this.keystore);
        }
    }

    @Override
    public void start() throws IOException {
        this.createCustomTrustManagers();
        this.saveRuntimeToken(this.getRuntimeToken(this.client.getClientVersion(), this.mailbox));
        this.connectionPinger.start();
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.connectionPinger.stop(deadline);
    }

    private void saveRuntimeToken(String[] token) {
        if (token.length == 2) {
            this.runtimeToken = token[0];
            this.vmId = token[1];
            this.listener.authenticated();
        } else {
            this.listener.syncFailed(new Result<String[]>(new IOException("Protocol failure, wrong auth response")));
        }
    }

    private X509TrustManager getX509TrustManager(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(ks);
        for (TrustManager tm : tmFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new NoSuchAlgorithmException();
    }

    private void createCustomTrustManagers() throws CRSException {
        try {
            char[] password = this.keyStorePasswd.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            try (InputStream keystoreStream = this.keystore == null ? this.getClass().getResourceAsStream("crs.jks") : new FileInputStream(this.keystore);){
                ks.load(keystoreStream, password);
            }
            KeyManagerFactory kmFactory = null;
            NoSuchAlgorithmException lastException = null;
            if (Tweaks.KEYMANAGER_FACTORY != null) {
                String fn = null;
                for (String factoryName : Tweaks.KEYMANAGER_FACTORY.split(",")) {
                    fn = "default".equals(factoryName) ? KeyManagerFactory.getDefaultAlgorithm() : factoryName;
                    try {
                        kmFactory = KeyManagerFactory.getInstance(fn);
                        break;
                    }
                    catch (NoSuchAlgorithmException e) {
                        lastException = e;
                        this.logger.debug("Kaymanager algorithm '%s' wasn't found: %s", factoryName, e);
                    }
                }
                this.logger.debug("Based on configuration '%s', Keymanager algorithm '%s' was chosen", Tweaks.KEYMANAGER_FACTORY, fn);
            }
            if (kmFactory == null) {
                throw new CRSException(-4, "Unrecoverable internal error: failed to initialize keymanager factory based on the configuration: '" + Tweaks.KEYMANAGER_FACTORY + "'", lastException);
            }
            kmFactory.init(ks, password);
            X509TrustManager customTrustManager = this.createCustomTrustManager(ks);
            KeyManager[] keyManagers = kmFactory.getKeyManagers();
            this.sslSocketFactory = this.createSocketFactory(customTrustManager, keyManagers);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            this.unrecoverableError = true;
            throw new CRSException(-4, "Unrecoverable internal error: ", ex);
        }
    }

    private X509TrustManager createCustomTrustManager(KeyStore ks) throws NoSuchAlgorithmException, KeyStoreException {
        final X509TrustManager tmPrivate = this.getX509TrustManager(ks);
        final X509TrustManager tmDefault = this.getX509TrustManager(null);
        int icount1 = tmPrivate.getAcceptedIssuers().length;
        int icount2 = tmDefault.getAcceptedIssuers().length;
        final X509Certificate[] allIssuers = new X509Certificate[icount1 + icount2];
        System.arraycopy(tmPrivate.getAcceptedIssuers(), 0, allIssuers, 0, icount1);
        System.arraycopy(tmDefault.getAcceptedIssuers(), 0, allIssuers, icount1, icount2);
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                throw new CertificateException("unsupported operation");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    tmPrivate.checkServerTrusted(chain, authType);
                }
                catch (CertificateException ignored) {
                    tmDefault.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return allIssuers;
            }
        };
    }

    private SSLSocketFactory createSocketFactory(X509TrustManager tm, KeyManager[] keyManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, new TrustManager[]{tm}, null);
        return sslContext.getSocketFactory();
    }

    private HttpsURLConnection createConnection(String url) throws IOException {
        if (this.unrecoverableError) {
            throw new IOException("Unrecoverable error");
        }
        URL endpoint = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)endpoint.openConnection();
        con.setUseCaches(false);
        con.setConnectTimeout(30000);
        con.setReadTimeout(20000);
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_JSON);
        con.setRequestProperty(HEADER_ACCEPT, MEDIA_TYPE_TEXT_PLAIN);
        con.setRequestProperty(HEADER_CONNECTION, KEEP_ALIVE);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<String[]> requestAny(String resource, String method, ConnectionConsumer headerWriter, ConnectionConsumer requestWriter) throws IOException {
        long startTime = Utils.currentTimeCount();
        Response<String[]> response = new Response<String[]>();
        HttpsURLConnection con = this.createConnection(resource);
        con.setSSLSocketFactory(this.sslSocketFactory);
        if (method.equals(METHOD_PATCH)) {
            con.setRequestProperty("X-HTTP-Method-Override", method);
            method = METHOD_POST;
        }
        con.setRequestProperty(HEADER_AUTHORIZATION, "Bearer " + this.runtimeToken);
        con.setRequestProperty(AGENT_VERSION, this.client.getClientVersion() + '+' + this.client.getClientRevision());
        con.setRequestMethod(method);
        headerWriter.consume(con);
        con.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(startTime), con);
        try {
            requestWriter.consume(con);
            int code = con.getResponseCode();
            String message = con.getResponseMessage();
            response.code(code);
            response.message(message);
            this.logger.trace("requestAny response code %d", code);
            if (code >= 400 && con.getErrorStream() != null) {
                response.error(this.readStream(con.getErrorStream()));
            } else if (con.getInputStream() != null) {
                response.payload(this.readStreamToArray(con.getInputStream()));
            }
            if (!response.successful()) {
                this.logger.warning("Unsuccesfull response on attempt to %s %s: %s", method, resource, response);
            }
            if (code == 401 && Utils.currentTimeCount() > this.nextRuntimeTokenRefreshTimeCount) {
                this.saveRuntimeToken(this.refreshRuntimeToken(this.runtimeToken));
                Response<String[]> response2 = this.requestAny(resource, method, headerWriter, requestWriter);
                return response2;
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
            con.disconnect();
        }
        return response;
    }

    @Override
    public Response<String[]> sendVMEventBatch(Collection<VMEvent> events) throws IOException {
        Iterator<Payload.DataWithCounters> it = VMEvent.toJsonArrays(events, 0x200000);
        Response<String[]> result = new Response<String[]>();
        while (it.hasNext()) {
            Payload.DataWithCounters dataWithCounters = it.next();
            String data = dataWithCounters.data;
            if (this.vmId == null) {
                throw new RuntimeException("The race: trying to send event to the cloud before client authentication completed");
            }
            String endpoint = this.restAPI + EVENT_RESOURCE.replace("{vmId}", this.vmId);
            result = this.requestAnyJson(endpoint, METHOD_POST, data, con -> {
                con.setRequestProperty(HEADER_EVENT_BATCH_SEND_TIME, Long.toString(Utils.currentTimeMillis()));
                con.setRequestProperty(HEADER_EVENT_BATCH_ID, Utils.uuid());
                if (this.logger.isEnabled(Logger.Level.DEBUG)) {
                    this.logger.debug("Sending VM event batch: batchId=%s, events=%d, timestamp=%s", con.getRequestProperty(HEADER_EVENT_BATCH_ID), events.size(), con.getRequestProperty(HEADER_EVENT_BATCH_SEND_TIME));
                }
            });
            String[] payload = result.getPayload();
            if (payload != null) {
                String l;
                int i = 0;
                block11: while (i < payload.length && (l = payload[i++]).startsWith("#")) {
                    int lines;
                    if ((lines = Integer.parseInt(payload[i++])) > payload.length - i) {
                        this.logger.error("Protocol error - section %s declares more lines than available in the payload", l);
                        lines = payload.length - i;
                    }
                    switch (l) {
                        case "#requests": {
                            for (int j = 0; j < lines; ++j) {
                                ServerRequest request = null;
                                try {
                                    request = ServerRequest.parse(payload[i++]);
                                }
                                catch (Throwable th) {
                                    this.logger.error("Unexpected error, while we read the response body from the server - %s", th);
                                }
                                if (request != null) {
                                    ServerRequestsService.addServiceRequest(request);
                                    continue;
                                }
                                this.logger.warning("Unhandled server request: %s", request);
                            }
                            continue block11;
                        }
                        case "#features": {
                            ArrayList<String> options = new ArrayList<String>();
                            for (int j = 0; j < lines; ++j) {
                                options.add(payload[i++]);
                            }
                            FeatureFlagsConfiguration.updateFeatureFlags(options);
                            break;
                        }
                        default: {
                            this.logger.debug("Unexpected section [%s] in response payload", l);
                            i += lines;
                        }
                    }
                }
            }
            if (!result.successful()) break;
            PerformanceMetrics.logEventBatch(events.size());
            dataWithCounters.counters.forEach((k, c) -> {
                switch (k) {
                    case VM_CLASS_LOADED: {
                        PerformanceMetrics.logClassLoads(c);
                        break;
                    }
                    case VM_JAR_LOADED: {
                        PerformanceMetrics.logJarLoads(c);
                        break;
                    }
                    case VM_METHOD_FIRST_CALLED: {
                        PerformanceMetrics.logMethodEntries(c);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public boolean requestWithRetries(InterfaceConnectionManager.ResponseSupplier request, String requestName, int maxRetries, long retrySleep) {
        Result<Object> result = this.requestWithRetriesImpl(request, requestName, maxRetries, retrySleep);
        if (!result.successful()) {
            if (this.isUpgradeNeeded(result)) {
                result = new Result(this.createUpgradeNeededException(result));
            }
            this.listener.syncFailed(result);
            return false;
        }
        return true;
    }

    private Result<String[]> requestWithRetriesImpl(InterfaceConnectionManager.ResponseSupplier request, String requestName, int maxRetries, long retrySleep) {
        Result<Object> result;
        int attempt = 1;
        long startTime = Utils.currentTimeCount();
        while (true) {
            try {
                result = new Result<String[]>(request.get());
                if (result.successful()) {
                    this.logger.trace("Request %s succeeded on attempt %d, elapsed %s", requestName, attempt, Utils.elapsedTimeString(startTime));
                    return result;
                }
                this.logger.warning("Request %s failed on attempt %s of %s, elapsed %s: %s", requestName, attempt, maxRetries, Utils.elapsedTimeString(startTime), result.errorString());
            }
            catch (IOException ioe) {
                this.logger.warning("Request %s failed on attempt %s of %s, elapsed %s: %s", requestName, attempt, maxRetries, Utils.elapsedTimeString(startTime), ioe.toString());
                result = new Result(ioe);
            }
            if (!result.canRetry() || ++attempt > maxRetries) break;
            Utils.sleep(retrySleep);
        }
        this.logger.warning("Request %s aborted after %d attempt, elapsed %s", requestName, attempt, Utils.elapsedTimeString(startTime));
        return result;
    }

    Response<String[]> requestAnyJson(String resource, String method, String payload, ConnectionConsumer headerWriter) throws IOException {
        return this.requestAny(resource, method, headerWriter, con -> {
            if (Tweaks.DEBUG_REQUEST_ANY_JSON) {
                this.logger.trace("%s %s\n", method, resource);
                this.logger.trace("%s\n\n", payload);
            }
            this.writeData(con, payload.getBytes(UTF_8));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        long totalLength = 0L;
        byte[] readBuffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(readBuffer)) != -1) {
                outputStream.write(readBuffer, 0, length);
                totalLength += (long)length;
            }
        }
        finally {
            PerformanceMetrics.logBytes(totalLength, 0L);
            inputStream.close();
        }
        return outputStream.toString(UTF_8);
    }

    private String[] readStreamToArray(InputStream is) throws IOException {
        String s;
        LinkedList<String> result = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((s = reader.readLine()) != null) {
            result.add(s);
        }
        reader.close();
        return result.toArray(new String[0]);
    }

    private void writeData(URLConnection con, byte[] data, int size) throws IOException {
        try (OutputStream out = con.getOutputStream();){
            out.write(data, 0, size);
            PerformanceMetrics.logBytes(0L, size);
        }
    }

    private void writeData(URLConnection con, byte[] data) throws IOException {
        this.writeData(con, data, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response putBinaryData(String location, ConnectionConsumer requestWriter) throws IOException {
        long startTime = Utils.currentTimeCount();
        Response response = new Response();
        HttpsURLConnection con = this.createConnection(location);
        con.setSSLSocketFactory(this.sslSocketFactory);
        con.setRequestProperty(HEADER_CONTENT_TYPE, MEDIA_TYPE_BINARY);
        con.setRequestMethod(METHOD_PUT);
        con.connect();
        PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(startTime), con);
        try {
            requestWriter.consume(con);
            response.code(con.getResponseCode());
            response.message(con.getResponseMessage());
            if (!response.successful()) {
                response.error(this.readStream(con.getErrorStream()));
            }
        }
        finally {
            PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
            con.disconnect();
        }
        return response;
    }

    @Override
    public Response<String[]> sendVMArtifactChunk(VMArtifactChunk chunk, DataWriter dataWriter) throws IOException {
        String[] created;
        String location;
        Response uploadResponse;
        Response<String[]> createResponse = this.requestAnyJson(this.restAPI + ARTIFACT_CHUNK_RESOURCE, METHOD_POST, chunk.toJson(), NONE);
        if (createResponse.successful() && dataWriter != null && !(uploadResponse = this.putBinaryData(location = (created = createResponse.getPayload())[0], connection -> dataWriter.writeData(new Utils.CountingOutputStream(connection.getOutputStream(), writtenBytes -> PerformanceMetrics.logBytes(0L, writtenBytes))))).successful()) {
            throw new IOException("Created VM artifact chunk failed to upload data: chunkId=" + created[1] + ", error=" + uploadResponse.getError());
        }
        return createResponse;
    }

    private Response<String[]> retrieveRuntimeToken(HttpsURLConnection con) throws IOException {
        Response<String[]> response = new Response().code(con.getResponseCode()).message(con.getResponseMessage());
        if (!response.successful()) {
            if (con.getErrorStream() != null) {
                response.error(this.readStream(con.getErrorStream()));
            }
            return response;
        }
        return response.payload(this.readStreamToArray(con.getInputStream()));
    }

    private String[] getRuntimeToken(final String clientVersion, final String mailbox) throws CRSException {
        this.logger.info("Get runtime token: clientVersion=%s, mailbox=%s", clientVersion, mailbox);
        final long startTime = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        Result<String[]> result = this.requestWithRetriesImpl(new InterfaceConnectionManager.ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long attemptStartTime = Utils.currentTimeCount();
                HttpsURLConnection con = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE + "?clientVersion=" + clientVersion + "&mailbox=" + mailbox);
                con.setSSLSocketFactory(ConnectionManager.this.sslSocketFactory);
                if (ConnectionManager.this.apiKey != null) {
                    con.setRequestProperty(ConnectionManager.HEADER_API_KEY, ConnectionManager.this.apiKey);
                }
                con.setRequestMethod(ConnectionManager.METHOD_GET);
                con.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(attemptStartTime), con);
                try {
                    Response response = ConnectionManager.this.retrieveRuntimeToken(con);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
                    con.disconnect();
                }
            }
        }, "getRuntimeToken", Tweaks.MAX_RETRIES, Tweaks.RETRY_SLEEP);
        if (!result.successful()) {
            this.throwIfUpgradeIsNeeded(result);
            throw new CRSException(this.client, -2, "Cannot get runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    private void throwIfUpgradeIsNeeded(Result<?> result) throws CRSException {
        if (this.isUpgradeNeeded(result)) {
            throw this.createUpgradeNeededException(result);
        }
    }

    private boolean isUpgradeNeeded(Result<?> result) {
        return result.hasResponse() && result.getResponse().getCode() == 426;
    }

    private CRSException createUpgradeNeededException(Result<?> result) {
        String error;
        String string = error = result.hasResponse() ? result.getResponse().getError() : null;
        if (error == null || error.isEmpty()) {
            error = "Unsupported version";
        }
        return new CRSException(this.client, -5, error, result);
    }

    private String[] refreshRuntimeToken(final String runtimeToken) throws IOException {
        final long startTime = Utils.currentTimeCount();
        this.nextRuntimeTokenRefreshTimeCount = Utils.nextTimeCount(300000L);
        this.logger.info("Refresh runtime token", new Object[0]);
        Result<String[]> result = this.requestWithRetriesImpl(new InterfaceConnectionManager.ResponseSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response<String[]> get() throws IOException {
                long attemptStartTime = Utils.currentTimeCount();
                HttpsURLConnection con = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI + ConnectionManager.AUTH_TOKEN_RESOURCE);
                con.setSSLSocketFactory(ConnectionManager.this.sslSocketFactory);
                if (ConnectionManager.this.apiKey != null) {
                    con.setRequestProperty(ConnectionManager.HEADER_API_KEY, ConnectionManager.this.apiKey);
                }
                con.setRequestProperty(ConnectionManager.HEADER_CONTENT_TYPE, ConnectionManager.MEDIA_TYPE_TEXT_PLAIN);
                con.setRequestMethod(ConnectionManager.METHOD_POST);
                con.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(attemptStartTime), con);
                try {
                    con.getOutputStream().write(runtimeToken.getBytes());
                    Response response = ConnectionManager.this.retrieveRuntimeToken(con);
                    return response;
                }
                finally {
                    PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
                    con.disconnect();
                }
            }
        }, "refreshRuntimeToken", Tweaks.MAX_RETRIES, Tweaks.RETRY_SLEEP);
        if (!result.successful()) {
            this.throwIfUpgradeIsNeeded(result);
            throw new CRSException(this.client, -2, "Cannot refresh runtime token: ", result);
        }
        return result.getResponse().getPayload();
    }

    @Override
    public String getVmId() {
        return this.vmId;
    }

    @Override
    public String getMailbox() {
        return this.mailbox;
    }

    @Override
    public String getRestAPI() {
        return this.restAPI;
    }

    private static interface ConnectionConsumer {
        public void consume(HttpsURLConnection var1) throws IOException;
    }

    private class HttpConnectionPinger
    implements ClientService {
        private final long pingPeriod;
        private final TimeUnit timeUnit;
        private final ReferenceFactory referenceFactory;
        private volatile ScheduledExecutorService pinger;

        private HttpConnectionPinger(ReferenceFactory referenceFactory, long pingPeriod, TimeUnit timeUnit) {
            this.pingPeriod = pingPeriod;
            this.timeUnit = timeUnit;
            this.referenceFactory = referenceFactory;
        }

        @Override
        public void start() {
            this.pinger = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread t = new Thread(this.referenceFactory.getThreadGroup(), runnable);
                t.setName("CRSHttpConnectionPinger");
                t.setDaemon(true);
                return t;
            });
            this.pinger.scheduleAtFixedRate(this::ping, 0L, this.pingPeriod, this.timeUnit);
        }

        @Override
        public void stop(Utils.Deadline deadline) {
            if (this.pinger != null) {
                this.pinger.shutdown();
                try {
                    long timeout = Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS));
                    if (!this.pinger.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                        this.pinger.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.logger().error("HTTP connection pinger was interrupted on timeout", new Object[0]);
                    this.pinger.shutdownNow();
                }
            }
        }

        @Override
        public void terminate() {
            this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ping() {
            long startTime = Utils.currentTimeCount();
            HttpURLConnection con = null;
            try {
                con = ConnectionManager.this.createConnection(ConnectionManager.this.restAPI);
                ((HttpsURLConnection)con).setSSLSocketFactory(ConnectionManager.this.sslSocketFactory);
                con.setRequestMethod(ConnectionManager.METHOD_OPTIONS);
                con.connect();
                PerformanceMetrics.logHandshakeTime(Utils.elapsedTimeMillis(startTime), (HttpsURLConnection)con);
                int code = con.getResponseCode();
                if (code >= 400 && con.getErrorStream() != null) {
                    this.logger().error("Received bad status code during HTTP connection pinging: code=%s, message=%s", code, con.getResponseMessage());
                    ConnectionManager.this.readStream(con.getErrorStream());
                } else if (con.getInputStream() != null) {
                    ConnectionManager.this.readStreamToArray(con.getInputStream());
                }
            }
            catch (InsufficientMemoryException | OutOfMemoryError ex) {
                throw ex;
            }
            catch (Exception e) {
                this.logger().error("Error occurred during HTTP connection pinging %s", e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
                PerformanceMetrics.logNetworkTime(Utils.elapsedTimeMillis(startTime));
            }
        }
    }
}

