/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.InterfaceConnectionManager;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Response;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.models.Payload;
import com.azul.crs.javaagent.client.models.VMArtifactChunk;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.service.DataWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class DummyConnectionManager
implements InterfaceConnectionManager {
    private static final String VM_EVENTS_OUTPUT_NAME = "VM_EVENTS_";
    private static final String VM_ARTIFACTS_OUTPUT_NAME = "VM_ARTIFACT_DATA_";
    private final String vmId;
    private final String mailbox;
    private final String restAPI;
    private final InterfaceConnectionManager.ConnectionListener listener;
    private PrintWriter vmEventsOutput;
    private PrintWriter vmArtifactChunksOutput;

    public DummyConnectionManager(Map<Client.ClientProp, Object> props, InterfaceConnectionManager.ConnectionListener listener) {
        this.listener = listener;
        this.vmId = UUID.randomUUID().toString();
        this.restAPI = (String)props.get((Object)Client.ClientProp.API_URL);
        this.mailbox = (String)props.get((Object)Client.ClientProp.API_MAILBOX);
    }

    @Override
    public Response<String[]> sendVMEventBatch(Collection<VMEvent> events) throws IOException {
        Iterator<Payload.DataWithCounters> it = VMEvent.toJsonArrays(events, 0x200000);
        while (it.hasNext()) {
            Payload.DataWithCounters dataWithCounters = it.next();
            String data = dataWithCounters.data;
            this.vmEventsOutput.println(data);
            PerformanceMetrics.logEventBatch(events.size());
            dataWithCounters.counters.forEach((k, c) -> {
                switch (k) {
                    case VM_CLASS_LOADED: {
                        PerformanceMetrics.logClassLoads(c);
                        break;
                    }
                    case VM_JAR_LOADED: {
                        PerformanceMetrics.logJarLoads(c);
                        break;
                    }
                    case VM_METHOD_FIRST_CALLED: {
                        PerformanceMetrics.logMethodEntries(c);
                    }
                }
            });
        }
        return null;
    }

    @Override
    public boolean requestWithRetries(InterfaceConnectionManager.ResponseSupplier request, String requestName, int maxRetries, long retrySleep) {
        try {
            request.get();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public Response<String[]> sendVMArtifactChunk(VMArtifactChunk chunk, DataWriter dataWriter) throws IOException {
        this.vmArtifactChunksOutput.println(chunk.toJson());
        if (dataWriter != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dataWriter.writeData(baos);
            this.vmArtifactChunksOutput.println(baos.toString());
        }
        Response<String[]> response = new Response<String[]>();
        response.code(200);
        return response;
    }

    @Override
    public String getVmId() {
        return this.vmId;
    }

    @Override
    public String getMailbox() {
        return this.mailbox;
    }

    @Override
    public String getRestAPI() {
        return this.restAPI;
    }

    @Override
    public void start() throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        Path events = Paths.get(tmpDir, VM_EVENTS_OUTPUT_NAME + this.vmId + ".log");
        this.vmEventsOutput = new PrintWriter(Files.newBufferedWriter(events, new OpenOption[0]));
        Path artifacts = Paths.get(tmpDir, VM_ARTIFACTS_OUTPUT_NAME + this.vmId + ".log");
        this.vmArtifactChunksOutput = new PrintWriter(Files.newBufferedWriter(artifacts, new OpenOption[0]));
        this.listener.authenticated();
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.vmEventsOutput.flush();
        this.vmEventsOutput.close();
        this.vmArtifactChunksOutput.flush();
        this.vmArtifactChunksOutput.close();
    }
}

