/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.JDKAccessFactory;
import com.azul.crs.javaagent.client.sysinfo.SystemInfoProvider;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Inventory {
    public static final String INSTANCE_TAGS_PROPERTY = "com.azul.crs.javaagent.instance.tags";
    public static final String HOST_NAME_KEY = "hostName";
    public static final String SYSTEM_PROPS_KEY = "systemProperties";
    public static final String CPU_INFO_KEY = "cpuInfo";
    public static final String MAIN_METHOD = "mainMethod";
    public static final String ENVIRONMENT_KEY = "osEnvironment";
    private Logger logger = Logger.getLogger(Inventory.class);
    private Map<String, Object> map = new LinkedHashMap<String, Object>();

    public Inventory populate(Predicate<String> envFilter, Predicate<String> sysPropsFilter) {
        this.map.put(HOST_NAME_KEY, this.hostName());
        this.map.put(SYSTEM_PROPS_KEY, new HashMap(this.systemProperties(sysPropsFilter)));
        this.map.put(ENVIRONMENT_KEY, this.osEnvironment());
        return this;
    }

    public Inventory systemInformation() {
        try {
            this.map.put(CPU_INFO_KEY, SystemInfoProvider.getCPUInfo());
        }
        catch (Exception ex) {
            this.logger.warning("Failed to get system information. The data may be incomplete", ex);
        }
        return this;
    }

    public Inventory mainMethod(String mainMethod) {
        if (mainMethod != null) {
            this.map.put(MAIN_METHOD, mainMethod);
        }
        return this;
    }

    public String hostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            this.logger.warning("cannot get host name %s", uhe.toString());
            String name = this.getHostNameViaReflection();
            if (name == null) {
                name = this.getHostNameFromNetworkInterface();
            }
            if (name == null) {
                name = "<UNKNOWN>";
            }
            return name;
        }
    }

    public static String instanceTags() {
        return System.getProperties().getProperty(INSTANCE_TAGS_PROPERTY);
    }

    public Map systemProperties(Predicate<String> sysPropsFilter) {
        Properties systemProperties = (Properties)System.getProperties().clone();
        return systemProperties.entrySet().stream().filter(e -> sysPropsFilter.test(e.getKey().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, String> osEnvironment() {
        String[] restrictedList = new String[]{"AZ_CRS_ARGUMENTS", "CRS_IMAGE", "CRS_OWNER", "CRS_SERVICE", "CRS_DATACENTER", "CRS_TAGS"};
        return System.getenv().entrySet().stream().filter(e -> Arrays.stream(restrictedList).anyMatch(((String)e.getKey())::equals)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<String> jvmArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments();
    }

    public Map<String, Object> toMap() {
        return this.map;
    }

    private String getHostNameViaReflection() {
        try {
            return JDKAccessFactory.getAccessor().getHostNameViaReflection();
        }
        catch (InternalError e) {
            this.logger.warning("cannot get host name", e);
            return null;
        }
    }

    private String getHostNameFromNetworkInterface() {
        try {
            String candidateName = null;
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                Enumeration<InetAddress> isa = ni.getInetAddresses();
                while (isa.hasMoreElements()) {
                    InetAddress ia = isa.nextElement();
                    if (ia instanceof Inet4Address) {
                        return ia.getCanonicalHostName();
                    }
                    candidateName = ia.getCanonicalHostName();
                }
            }
            return candidateName;
        }
        catch (SocketException e) {
            this.logger.warning("cannot get host name for iface %s", e.toString());
            return null;
        }
    }
}

