/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.JDKAccessor;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;

public class JDKAccessFactory {
    private static JDKAccessor jdkAccessor;

    public static synchronized JDKAccessor getAccessor(Instrumentation inst, Supplier<String> prepareAccessorJar) throws IOException, UnsupportedOperationException {
        if (jdkAccessor != null) {
            return jdkAccessor;
        }
        if (System.getProperty("java.version").startsWith("1.")) {
            return JDKAccessFactory.getAccessor();
        }
        try {
            Method getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
            Object javaBaseModule = getModuleMethod.invoke(Object.class, new Object[0]);
            Class<?> moduleClass = Class.forName("java.lang.Module");
            boolean isJavaBaseModifiable = (Boolean)Instrumentation.class.getDeclaredMethod("isModifiableModule", moduleClass).invoke((Object)inst, javaBaseModule);
            if (!isJavaBaseModifiable) {
                throw new UnsupportedOperationException("java.base is not modifiable");
            }
            inst.appendToBootstrapClassLoaderSearch(new JarFile(prepareAccessorJar.get()));
            JDKAccessor _jdkAccessor = new JDKAccessor();
            if (_jdkAccessor.getClass().getClassLoader() != null) {
                throw new UnsupportedOperationException("no access to bootstrap class loader");
            }
            HashSet<Object> myModule = new HashSet<Object>();
            myModule.add(getModuleMethod.invoke(JDKAccessor.class, new Object[0]));
            HashMap<String, HashSet<Object>> extraOpens = new HashMap<String, HashSet<Object>>();
            for (String packageToOpen : new String[]{"java.lang", "java.net", "java.nio", "java.util", "java.util.zip", "jdk.internal.loader", "jdk.internal.access", "jdk.internal.misc", "sun.net.dns", "sun.net.www.http", "sun.net.www.protocol.http", "sun.net.www.protocol.https"}) {
                if (Package.getPackage(packageToOpen) == null) continue;
                extraOpens.put(packageToOpen, myModule);
            }
            Instrumentation.class.getDeclaredMethod("redefineModule", moduleClass, Set.class, Map.class, Map.class, Set.class, Map.class).invoke((Object)inst, javaBaseModule, new HashSet(), new HashMap(), extraOpens, new HashSet(), new HashMap());
            jdkAccessor = _jdkAccessor;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return jdkAccessor;
    }

    public static synchronized JDKAccessor getAccessor() {
        if (jdkAccessor != null) {
            return jdkAccessor;
        }
        jdkAccessor = new JDKAccessor();
        return jdkAccessor;
    }
}

