/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum Options {
    UnlockExperimentalCRS(null),
    props(Options::readableFile),
    mode(Options::agentMode),
    delayTermination(Options::nonNegativeNumber, "0"),
    maxJarFileCacheSize(Options::nonNegativeNumber, Tweaks.forceFullJarLoadedEvents ? "9999999999" : "20480"),
    stackRecordId(Options::anyString),
    sendPOMData(Options::anyBoolean, "true", "true"),
    sendClassMethods(Options::anyBoolean, "false", "true"),
    notifyJarLoad(Options::anyBoolean, "true", "true"),
    notifyClassLoad(Options::anyBoolean, "true", "true"),
    memorySafeguards(Options::anyBoolean, "true", "true"),
    enable(null),
    lifetimejfr(Options::anyString),
    notifyFirstCall(Options::anyBoolean, "false", "true"),
    delayInitiation(Options::nonNegativeNumber, "2000", "2000"),
    forceSyncTimeout(Options::nonNegativeNumber),
    sendJVMLogs(Options::anyBoolean, "false", "true"),
    sendCRSLogs(Options::anyBoolean, "true", "true"),
    extraLogFile(Options::anyString),
    connectionManager(Options::anyString);

    private static final String DEFAULT_SHARED_PROPS_FILE = "az_crs.properties";
    private static final String DEFAULT_USER_PROPS_FILE;
    private String value;
    private Origin origin;
    private static final Map<Client.ClientProp, Object> clientProps;
    private static Collection<Map.Entry<String, String>> loggerOptions;
    private final BiFunction<Options, String, String> validator;
    private final String defaultValue;
    private final String emptyValue;

    private Options(BiFunction<Options, String, String> validator) {
        this(validator, null);
    }

    private Options(BiFunction<Options, String, String> validator, String defaultValue) {
        this(validator, defaultValue, null);
    }

    private Options(BiFunction<Options, String, String> validator, String defaultValue, String emptyValue) {
        this.validator = validator;
        this.defaultValue = defaultValue;
        this.emptyValue = emptyValue;
    }

    private static String readableFile(Options opt, String value) {
        Path path = Paths.get(value, new String[0]);
        if (Files.isReadable(path)) {
            try {
                return path.toFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Bad value '" + value + "'. " + opt.name() + " requires valid readable file path.");
    }

    private static String anyBoolean(Options opt, String value) {
        switch (value.toLowerCase()) {
            case "on": 
            case "yes": 
            case "true": 
            case "enable": {
                return "true";
            }
            case "off": 
            case "no": 
            case "false": 
            case "disable": {
                return "false";
            }
        }
        throw new IllegalArgumentException("Bad " + opt.name() + " option value '" + value + "'. Allowed values: '{yes|no|true|false|on|off|enable|disable}'");
    }

    private static String anyString(Options opt, String value) {
        return value;
    }

    private static String agentMode(Options opt, String value) {
        String v;
        switch (v = value.toLowerCase()) {
            case "on": 
            case "off": 
            case "auto": {
                return v;
            }
        }
        throw new IllegalArgumentException("Bad " + opt.name() + " option value '" + value + "'. Allowed values: '{on|off|auto}'.");
    }

    private static String nonNegativeNumber(Options opt, String value) {
        try {
            if (Long.parseLong(value) >= 0L) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bad " + opt.name() + " option value '" + value + "'. Non-negative number required.");
    }

    public static void checkIntegrity(Predicate<Options> isSupportedOption) {
        EnumSet.allOf(Options.class).stream().filter(o -> !isSupportedOption.test((Options)((Object)o))).filter(Options::isSet).forEach(o -> Logger.getLogger(Options.class).warning("%s is not supported and ignored", o.name()));
        if (isSupportedOption.test(notifyJarLoad) && isSupportedOption.test(notifyClassLoad) && notifyJarLoad.isSet() && !notifyJarLoad.isYes() && (!notifyClassLoad.isSet() || notifyClassLoad.isYes())) {
            notifyClassLoad.set("false", Origin.ERGONOMIC);
            Logger.getLogger(Options.class).warning("notifyClassLoad depends on notifyJarLoad and was disabled", new Object[0]);
        }
        if (isSupportedOption.test(notifyClassLoad) && isSupportedOption.test(notifyFirstCall) && notifyClassLoad.isSet() && !notifyClassLoad.isYes() && (!notifyFirstCall.isSet() || notifyFirstCall.isYes())) {
            notifyFirstCall.set("false", Origin.ERGONOMIC);
            Logger.getLogger(Options.class).warning("notifyFirstCall depends on notifyClassLoad and was disabled", new Object[0]);
        }
        EnumSet.allOf(Options.class).stream().filter(isSupportedOption).filter(o -> o.value == null && o.defaultValue != null).forEach(o -> o.set(o.defaultValue, Origin.DEFAULT));
    }

    public static void dump(String fullAgentName, Predicate<Options> isSupportedOption) {
        Logger log = Logger.getLogger(Options.class);
        if (log.isEnabled(Logger.Level.DEBUG)) {
            Set setOptions = EnumSet.allOf(Options.class).stream().filter(isSupportedOption).filter(Options::isSet).collect(Collectors.toSet());
            Function<Function, Integer> maxLength = m -> setOptions.stream().map(m).mapToInt(String::length).max().orElse(0);
            int maxNameLength = maxLength.apply(Enum::name);
            int maxValLength = maxLength.apply(Options::get);
            int maxOriginLength = maxLength.apply(o -> o.origin.name());
            log.info("Effective %s options: %s", fullAgentName, setOptions.stream().sorted(Comparator.comparing(Enum::name)).map(o -> String.format("\n   %-" + maxNameLength + "s = %" + maxValLength + "s [ %-" + maxOriginLength + "s ]", new Object[]{o.name(), o.value, o.origin})).collect(Collectors.joining()));
            log.info("Effective %s log configuration: %s", fullAgentName, loggerOptions.stream().sorted(Map.Entry.comparingByKey()).map(kv -> String.format("\n   %s = %s", kv.getKey(), kv.getValue())).collect(Collectors.joining()));
        }
    }

    private static void updateCrsArgs(Map<String, String> map, Options opt) {
        map.put(opt.toString(), opt.get());
    }

    public static Map<String, String> dumpCrsArgs() {
        HashMap<String, String> map = new HashMap<String, String>();
        Options.updateCrsArgs(map, mode);
        Options.updateCrsArgs(map, delayTermination);
        Options.updateCrsArgs(map, maxJarFileCacheSize);
        Options.updateCrsArgs(map, sendPOMData);
        Options.updateCrsArgs(map, sendClassMethods);
        Options.updateCrsArgs(map, notifyJarLoad);
        Options.updateCrsArgs(map, notifyClassLoad);
        Options.updateCrsArgs(map, lifetimejfr);
        Options.updateCrsArgs(map, notifyFirstCall);
        Options.updateCrsArgs(map, delayInitiation);
        Options.updateCrsArgs(map, forceSyncTimeout);
        Options.updateCrsArgs(map, sendJVMLogs);
        Options.updateCrsArgs(map, sendCRSLogs);
        map.put("log", loggerOptions.stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        return map;
    }

    String get() {
        return this.value;
    }

    boolean isSet() {
        return this.value != null;
    }

    public int getInt() {
        return Integer.parseInt(this.value);
    }

    public long getLong() {
        return Long.parseLong(this.value);
    }

    public boolean isYes() {
        return Boolean.parseBoolean(this.value);
    }

    void set(String value, Origin origin) {
        try {
            this.value = "".equals(value) ? this.emptyValue : (this.validator == null ? value : this.validator.apply(this, value));
            this.origin = origin;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(Options.class).error("%s", ex);
            this.value = this.defaultValue;
            this.origin = Origin.ERGONOMIC;
        }
    }

    static void read(String commandLineArgs) {
        File propsFile;
        String envArgs = System.getenv("AZ_CRS_ARGUMENTS");
        String explicitPropsFile = Options.getPropFileNameFromArgs(commandLineArgs);
        if (explicitPropsFile == null) {
            explicitPropsFile = Options.getPropFileNameFromArgs(envArgs);
        }
        if (explicitPropsFile != null) {
            propsFile = new File(explicitPropsFile);
            if (!propsFile.exists()) {
                Logger.getLogger(Options.class).error("specified properties file '%s' does not exist", propsFile.getPath());
            }
        } else {
            propsFile = new File(System.getProperty("user.home") + File.separatorChar + DEFAULT_USER_PROPS_FILE);
            if (!propsFile.exists()) {
                propsFile = new File(System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + DEFAULT_SHARED_PROPS_FILE);
            }
        }
        if (propsFile.exists()) {
            Options.tryLoadingProps(propsFile);
        }
        Options.readArgs(envArgs, Origin.ENVIRONMENT);
        Options.readArgs(commandLineArgs, Origin.COMMANDLINE);
        Logger.parseOptions(loggerOptions);
    }

    private static String getPropFileNameFromArgs(String args) {
        String propsFile = null;
        int sPos = 0;
        String mode1 = "mode=on,";
        String mode2 = "mode=auto,";
        if (args != null && args.startsWith("mode=on,")) {
            sPos += "mode=on,".length();
        }
        if (args != null && args.startsWith("mode=auto,")) {
            sPos += "mode=auto,".length();
        }
        String failOn = "failJVMOnError,";
        if (args != null && args.startsWith("failJVMOnError,")) {
            sPos += "failJVMOnError,".length();
        }
        if (args != null && args.length() > sPos) {
            int ePos;
            int cPos = args.indexOf(44, sPos);
            if (cPos < 0) {
                cPos = args.length();
            }
            if (args.charAt(sPos) != ',' && ((ePos = args.indexOf(61, sPos)) < 0 || ePos > cPos)) {
                try {
                    Options.valueOf(args.substring(sPos, cPos));
                }
                catch (IllegalArgumentException theArgumentIsNotAnOptionName) {
                    propsFile = args.substring(sPos, cPos);
                }
            }
            String propsName = props.name() + "=";
            int propsNameLength = propsName.length();
            do {
                if ((cPos = args.indexOf(44, sPos)) < 0) {
                    cPos = args.length();
                }
                if (!args.startsWith(propsName, sPos)) continue;
                propsFile = args.substring(sPos + propsNameLength, cPos);
                break;
            } while ((sPos = cPos + 1) < args.length());
        }
        return propsFile;
    }

    private static void readArgs(String args, Origin origin) {
        int cPos;
        if (args == null) {
            return;
        }
        int sPos = 0;
        do {
            String value;
            int ePos;
            if ((cPos = args.indexOf(44, sPos)) == -1) {
                cPos = args.length();
            }
            if ((ePos = args.indexOf(61, sPos)) == -1 || ePos > cPos) {
                ePos = cPos;
            }
            String name = args.substring(sPos, ePos);
            String string = value = ePos == cPos ? "" : args.substring(ePos + 1, cPos);
            if (props.name().equals(name)) continue;
            Options.process(name, value, sPos == 0 && ePos == cPos, origin);
        } while ((sPos = cPos + 1) < args.length());
    }

    private static void process(String name, String value, boolean ignoreMaybePropsFile, Origin origin) {
        block9: {
            if (name.equals("log") || name.startsWith("log+") || name.startsWith("log:")) {
                loggerOptions.add(new AbstractMap.SimpleEntry<String, String>(name, value));
            } else if (props.name().equals(name)) {
                Options.tryLoadingProps(new File(value));
            } else if (name.length() > 0) {
                for (Client.ClientProp p : (Client.ClientProp[])Client.ClientProp.class.getEnumConstants()) {
                    if (!p.value().equals(name)) continue;
                    clientProps.put(p, value);
                    return;
                }
                try {
                    Options.valueOf(name).set(value, origin);
                }
                catch (IllegalArgumentException iae) {
                    if (ignoreMaybePropsFile) break block9;
                    Logger.getLogger(Options.class).error("unrecognized CRS agent option %s ignored", name);
                }
            }
        }
        if (Tweaks.FORCE_TRACE_LOGGING) {
            loggerOptions = new LinkedList<Map.Entry<String, String>>();
            loggerOptions.add(new AbstractMap.SimpleEntry<String, String>("log", "trace+stack+time"));
        }
    }

    private static void tryLoadingProps(File file) {
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            props.load(is);
            for (String name : props.stringPropertyNames()) {
                Options.process(name, props.getProperty(name), false, Origin.PROPERTIES);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Options.class).error("cannot load specified properties file %s: %s", file.getPath(), ex);
        }
    }

    public static Map<Client.ClientProp, Object> getClientProps() {
        return clientProps;
    }

    static {
        DEFAULT_USER_PROPS_FILE = ".az_crs" + File.separatorChar + "config.properties";
        clientProps = new HashMap<Client.ClientProp, Object>();
        loggerOptions = new LinkedList<Map.Entry<String, String>>();
    }

    public static enum Origin {
        DEFAULT,
        COMMANDLINE,
        ENVIRONMENT,
        PROPERTIES,
        ERGONOMIC;

    }
}

