/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.HttpsURLConnection;

public class PerformanceMetrics {
    private static final Logger logger = Logger.getLogger(PerformanceMetrics.class);
    private static JDKAccessor jdkAccessor;
    private final AtomicLong communicationMillis = new AtomicLong();
    private final AtomicLong numBytesOut = new AtomicLong();
    private final AtomicLong numBytesIn = new AtomicLong();
    private long shutdownMillis;
    private final AtomicLong preShutdownMillis = new AtomicLong();
    private final AtomicLong numEvents = new AtomicLong();
    private final AtomicLong numEventBatches = new AtomicLong();
    private final AtomicLong[] numEventHistogram = new AtomicLong[20];
    private final AtomicLong numConnections = new AtomicLong();
    private final AtomicLong numRequests = new AtomicLong();
    private final AtomicLong handshakeMillis = new AtomicLong();
    private final AtomicInteger maxQueueLength = new AtomicInteger();
    private final AtomicLong numBytesInArtifacts = new AtomicLong();
    private final AtomicLong numClassLoads = new AtomicLong();
    private final AtomicLong numJarLoads = new AtomicLong();
    private final AtomicLong numMethodEntries = new AtomicLong();
    private final AtomicLong numJarCacheFilesCreated = new AtomicLong();
    private final transient AtomicLong currentJarCacheTotalSize = new AtomicLong();
    private final AtomicLong numBytesJarCacheTotal = new AtomicLong();
    private final AtomicLong numBytesJarCacheMaxOnFS = new AtomicLong();
    private final AtomicLong numNotConfirmedJarLoads = new AtomicLong();
    private final AtomicLong numPostponedNoSpaceJarLoads = new AtomicLong();
    private final AtomicLong jarsWaitingMillis = new AtomicLong();
    private final AtomicLong numSkippedClassLoadEvents = new AtomicLong();
    private final AtomicLong numSkippedSendingEvents = new AtomicLong();
    private static final Map<String, Number> fieldDesc;
    private static PerformanceMetrics instance;

    public static void init(JDKAccessor jdkAccessor) {
        PerformanceMetrics.jdkAccessor = jdkAccessor;
        instance = new PerformanceMetrics();
        for (int i = 0; i < PerformanceMetrics.instance.numEventHistogram.length; ++i) {
            PerformanceMetrics.instance.numEventHistogram[i] = new AtomicLong();
        }
        for (Field f : PerformanceMetrics.class.getDeclaredFields()) {
            if (!Number.class.isAssignableFrom(f.getType()) || Modifier.isTransient(f.getModifiers())) continue;
            try {
                fieldDesc.put(f.getName(), (Number)f.get(instance));
            }
            catch (IllegalAccessException shouldNotHappen) {
                shouldNotHappen.printStackTrace();
            }
        }
    }

    static void logNetworkTime(long duration) {
        PerformanceMetrics.instance.communicationMillis.addAndGet(duration);
    }

    static void logHandshakeTime(long duration, HttpsURLConnection con) {
        PerformanceMetrics.instance.handshakeMillis.addAndGet(duration);
        PerformanceMetrics.instance.numRequests.incrementAndGet();
        if (jdkAccessor != null && jdkAccessor.isNotCachedHttpsURLConnection(con)) {
            PerformanceMetrics.instance.numConnections.incrementAndGet();
        } else if (jdkAccessor == null) {
            logger.trace("Number of established connection is not increased: no jdkAccessor is available", new Object[0]);
        } else {
            logger.trace("Number of established connection is not increased: used connection form internal pool", new Object[0]);
        }
    }

    static void logBytes(long in, long out) {
        PerformanceMetrics.instance.numBytesIn.addAndGet(in);
        PerformanceMetrics.instance.numBytesOut.addAndGet(out);
    }

    static void logShutdown(long duration) {
        PerformanceMetrics.instance.shutdownMillis = duration;
    }

    public static void logEventBatch(long size) {
        PerformanceMetrics.instance.numEvents.addAndGet(size);
        PerformanceMetrics.instance.numEventBatches.incrementAndGet();
        PerformanceMetrics.instance.numEventHistogram[(int)(Math.log(size) / Math.log(2.0))].incrementAndGet();
    }

    public static void logClassLoads(long count) {
        PerformanceMetrics.instance.numClassLoads.addAndGet(count);
    }

    public static void logJarLoads(long count) {
        PerformanceMetrics.instance.numJarLoads.addAndGet(count);
    }

    public static void logMethodEntries(long count) {
        PerformanceMetrics.instance.numMethodEntries.addAndGet(count);
    }

    public static void logEventQueueLength(int size) {
        int prev;
        AtomicInteger l = PerformanceMetrics.instance.maxQueueLength;
        while ((prev = l.get()) < size && !l.compareAndSet(prev, size)) {
        }
    }

    public static Map logPreShutdown(long duration) {
        PerformanceMetrics.instance.preShutdownMillis.set(duration);
        return instance.toEventPayload();
    }

    public static void logArtifactBytes(long bytes) {
        PerformanceMetrics.instance.numBytesInArtifacts.addAndGet(bytes);
    }

    public static void logJarCacheCreated(long bytes) {
        long max_value;
        long current_value;
        PerformanceMetrics.instance.currentJarCacheTotalSize.addAndGet(bytes);
        PerformanceMetrics.instance.numBytesJarCacheTotal.addAndGet(bytes);
        PerformanceMetrics.instance.numJarCacheFilesCreated.incrementAndGet();
        AtomicLong current = PerformanceMetrics.instance.currentJarCacheTotalSize;
        AtomicLong max = PerformanceMetrics.instance.numBytesJarCacheMaxOnFS;
        while ((current_value = current.get()) > (max_value = max.get()) && !max.compareAndSet(max_value, current_value)) {
        }
    }

    public static void logJarCacheDeleted(long bytes) {
        PerformanceMetrics.instance.currentJarCacheTotalSize.addAndGet(-bytes);
    }

    public static void logJarLoadEventReported() {
        PerformanceMetrics.instance.numNotConfirmedJarLoads.getAndIncrement();
    }

    public static void logJarLoadPostponedDueToNoSpaceYet() {
        PerformanceMetrics.instance.numPostponedNoSpaceJarLoads.getAndIncrement();
    }

    public static void logSkippedClassLoadEvent() {
        PerformanceMetrics.instance.numSkippedClassLoadEvents.getAndIncrement();
    }

    public static void logSkippedSendingEvent() {
        PerformanceMetrics.instance.numSkippedSendingEvents.getAndIncrement();
    }

    public static void logJarWaitingTime(long waitingTime) {
        PerformanceMetrics.instance.jarsWaitingMillis.getAndAdd(waitingTime);
    }

    public static void logJarLoadEventConfirmed() {
        PerformanceMetrics.instance.numNotConfirmedJarLoads.getAndDecrement();
    }

    private Map toEventPayload() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Map.Entry<String, Number> e : fieldDesc.entrySet()) {
            data.put(e.getKey(), e.getValue().toString());
        }
        return data;
    }

    static void report() {
        if (logger.isEnabled(Logger.Level.INFO)) {
            StringBuilder numEventsHistogram = new StringBuilder();
            for (AtomicLong hist : PerformanceMetrics.instance.numEventHistogram) {
                numEventsHistogram.append(hist.get()).append(' ');
            }
            logger.info("total communication duration %.3fs\nnumber of executed requests is %d using %d established connections, %.3fs spent in handshake\ntotal bytes in %.3fM\ntotal event data bytes out %.3fM\ntotal artifacts bytes %.3fM\nmaximum queue length %d\nshutdown delay %.3fs (pre %.3fs)\nclasses loaded %d\nskipped class load events %d\nskipped sending events %d\njars loaded %d\nnumber of postponed jars (not processed immediately after request) %d\ntotal jars load waiting time (in millis) %d\nnumber of unconfirmed jar load events %d\nmethods invoked %d\nevents sent %d batches %d [%s]\ntemp jars created %d\ntemp jars created total size %.3fM\ntemp jars max fs size consumed %.3fM", (double)PerformanceMetrics.instance.communicationMillis.get() / 1000.0, PerformanceMetrics.instance.numRequests.get(), PerformanceMetrics.instance.numConnections.get(), (double)PerformanceMetrics.instance.handshakeMillis.get() / 1000.0, (double)PerformanceMetrics.instance.numBytesIn.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesOut.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesInArtifacts.get() / 1024.0 / 1024.0, PerformanceMetrics.instance.maxQueueLength.get(), (double)PerformanceMetrics.instance.shutdownMillis / 1000.0, (double)PerformanceMetrics.instance.preShutdownMillis.get() / 1000.0, PerformanceMetrics.instance.numClassLoads.get(), PerformanceMetrics.instance.numSkippedClassLoadEvents.get(), PerformanceMetrics.instance.numSkippedSendingEvents.get(), PerformanceMetrics.instance.numJarLoads.get(), PerformanceMetrics.instance.numPostponedNoSpaceJarLoads.get(), PerformanceMetrics.instance.jarsWaitingMillis.get(), PerformanceMetrics.instance.numNotConfirmedJarLoads.get(), PerformanceMetrics.instance.numMethodEntries.get(), PerformanceMetrics.instance.numEvents.get(), PerformanceMetrics.instance.numEventBatches.get(), numEventsHistogram.toString(), PerformanceMetrics.instance.numJarCacheFilesCreated.get(), (double)PerformanceMetrics.instance.numBytesJarCacheTotal.get() / 1024.0 / 1024.0, (double)PerformanceMetrics.instance.numBytesJarCacheMaxOnFS.get() / 1024.0 / 1024.0);
        }
    }

    static {
        fieldDesc = new HashMap<String, Number>();
    }
}

