/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class Tweaks {
    private static final String PACKAGE_PREFIX = "com.azul.crs.javaagent.".substring(0, 13);
    private static final Set<String> allProperties = Collections.synchronizedSet(new HashSet());
    public static final boolean FORCE_TRACE_LOGGING = Tweaks.getBooleanProperty("force.trace.logging", false);
    public static final String malformedClassHash = "0000000000000000000000000000000000000000000000000000000000000000";
    public static final boolean DEBUG_JARLOAD = Tweaks.getBooleanProperty("jarload.debug", false);
    public static final boolean DEBUG_ASYNC_UTILS = Tweaks.getBooleanProperty("util.async.debug", DEBUG_JARLOAD);
    public static final boolean TRACE_CD_CONTENT = Tweaks.getBooleanProperty("jarload.debug.traceCDContent", false);
    public static final boolean ENABLE_NOTIFY_JAR_LOAD_BY_CLASSLOAD = Tweaks.getBooleanProperty("jarload.jarLoadByClassLoad", true);
    public static final boolean ENABLE_NOTIFY_JAR_LOAD_CALLBACK = Tweaks.getBooleanProperty("jarload.jarLoadByJarLoad", true);
    public static final boolean ENABLE_NOTIFY_JAR_LOAD_CLASS_PATH = Tweaks.getBooleanProperty("jarload.jarLoadByClassPath", true);
    public static final boolean sendCentralDirectoryHash = Tweaks.getBooleanPropertyDeprecated("jarload.sendCentralDirectoryHashOnRequest", true);
    public static final boolean sendJarEntriesHashes = Tweaks.getBooleanPropertyDeprecated("jarload.sendJarEntriesHashesOnRequest", true);
    public static final boolean sendJarEntriesShadedHashes = Tweaks.getBooleanPropertyDeprecated("jarload.sendJarEntriesShadedHashesOnRequest", true);
    public static final boolean sendClassMethods = Tweaks.getBooleanProperty("jarload.sendClassMethods", false);
    public static final boolean recursiveJarDiscovery = Tweaks.getBooleanPropertyDeprecated("jarload.recursiveJarDiscoveryOnRequest", true);
    public static final boolean proactiveJarDiscovery = Tweaks.getBooleanPropertyDeprecated("jarload.proactiveRecursiveJarDiscoveryOnJarLoad", false);
    public static final boolean nonBlockingJarDiscovery = Tweaks.getBooleanPropertyDeprecated("jarload.nonBlockingJarDiscovery", false);
    public static final int jarLoadedEventPreparingTimeout = Tweaks.getIntPropertyDeprecated("jarload.jarLoadedEventPreparingTimeout", 1800000);
    public static final int tempfilesTimeToLive = Tweaks.getIntProperty("jarload.tempfilesTimeToLive", jarLoadedEventPreparingTimeout);
    public static final boolean forceFullJarLoadedEvents = Tweaks.getBooleanProperty("jarload.forceFullJarLoadedEvents", false);
    public static final boolean postponeExitUntilNoUnconfirmedJars = Tweaks.getBooleanProperty("jarload.postponeExitUntilNoUnconfirmedJars", forceFullJarLoadedEvents);
    public static final boolean keepNestedToParentOrderOnForceFull = Tweaks.getBooleanProperty("jarload.debug.keepNestedToParentOrderOnForceFull", true);
    public static final boolean enableJarsFromClassLoaders = Tweaks.getBooleanProperty("jarload.enableFromClassLoaders", true);
    public static final int jarCacheSize = Tweaks.getIntProperty("jarload.dedupSize", 500);
    public static final int jarLoadMonitorTaskQueueSize = Tweaks.getIntProperty("jarload.jarLoadMonitorTaskQueueSize", 10000);
    public static final int UNUSED_jarLoadMonitorTaskQueuePostponeLimit = Tweaks.getIntPropertyDeprecated("jarload.jarLoadMonitorTaskQueuePostponeLimit", 10000000);
    public static final int UNUSED_jarLoadMonitorTaskQueuePostponeTimeout = Tweaks.getIntPropertyDeprecated("jarload.jarLoadMonitorTaskQueuePostponeTimeout", jarLoadedEventPreparingTimeout);
    public static final int UNUSED_jarLoadMonitorTaskQueuePollTimeout = Tweaks.getIntPropertyDeprecated("jarload.jarLoadMonitorTaskQueuePollTimeout", 10);
    public static final int UNUSED_jarLoadMonitorTaskQueueIdleTimeout = Tweaks.getIntPropertyDeprecated("jarload.jarLoadMonitorTaskQueueIdleTimeout", 5000);
    public static final int UNUSED_jarLoadMonitorTaskQueueInitialConcurrency = Tweaks.getIntPropertyDeprecated("client.jarload.concurrency", 1);
    public static final int UNUSED_jarLoadMonitorTaskQueueConcurrencyOnShutdown = Tweaks.getIntPropertyDeprecated("client.jarload.concurrencyOnExit", 8);
    public static final long UNUSED_HEARTBEAT_SLEEP = Tweaks.getIntPropertyDeprecated("jarload.pollingBackendSleepOnShutdown", 2000);
    public static final long UNUSED_YIELD_SLEEP = Tweaks.getIntPropertyDeprecated("jarload.yieldSleepOnShutdown", 10);
    public static final long UNUSED_LAST_HEARTBEAT_BEFORE_DEADLINE = Tweaks.getIntPropertyDeprecated("jarload.moreOftenPollingsForLastMS", 1000);
    public static final int dedupSize = Tweaks.getIntProperty("jarload.dedupSize", 500);
    public static final int MAX_QUEUE_SIZE = Tweaks.getIntProperty("eventService.maxQueueSize", 50000);
    public static final int MAX_WORKERS = Tweaks.getIntProperty("eventService.maxWorkers", 1);
    public static final int BATCH_SIZE = Tweaks.getIntProperty("eventService.batchSize", 1000);
    public static final int EVENT_MAX_RETRIES = Tweaks.getIntProperty("eventService.maxRetries", 3);
    public static final long EVENT_RETRY_SLEEP = Tweaks.getIntProperty("eventService.retrySleep", 100);
    public static final boolean DEBUG_EVENT_SERVICE = Tweaks.getBooleanProperty("eventService.debug", false);
    public static final int DEFAULT_BUFFER_SIZE = Tweaks.getIntProperty("jarload.genericProvider.bufferSize", 8192);
    public static final int genericCentralDirectoryMaxChunks = Tweaks.getIntProperty("jarload.genericProvider.maxBuffers", 1024);
    public static final boolean DEBUG_ZIPTOOLS = Tweaks.getBooleanProperty("jarload.debug.ziptools", false);
    public static final boolean PRETTY_PRINT_JSON = Tweaks.getBooleanProperty("client.enablePrettyPrint", false);
    public static final int MAX_RETRIES = Tweaks.getIntProperty("client.getRuntimeTokenNumberOfRetries", 5);
    public static final long RETRY_SLEEP = Tweaks.getIntProperty("client.getRuntimeTokenSleepBetweenRetries", 3000);
    public static final long POLL_TIMEOUT = Tweaks.getIntProperty("service.queuePollTimeout", 50);
    public static final boolean DEBUG_REQUEST_ANY_JSON = Tweaks.getBooleanProperty("client.traceTraffic", false);
    public static final boolean WAIT_ALL_JAR_REQUESTS = Tweaks.getBooleanProperty("jarload.waitForAllDetailsRequests", postponeExitUntilNoUnconfirmedJars);
    public static final boolean UGLY_PRETTY_PRINT_FOR_DEBUG = Tweaks.getBooleanProperty("util.logging.prettyPrintForDebug", false);
    public static final boolean FORCE_PRINT_STACKTRACE_IN_ERROR = Tweaks.getBooleanProperty("util.logging.forceStacktraceInErrorLogEntry", false);
    public static final String FIRST_CALL_PROCESSING_CHAIN = Tweaks.getStringProperty("firstCall.transformationChain", "INDY,MIRROR");
    public static final boolean DEBUG_FIRST_CALLS = Tweaks.getBooleanProperty("firstCall.debug", false);
    public static final boolean PRINT_FIRST_METHODS = Tweaks.getBooleanProperty("firstCall.printReportedMethods", false);
    public static final boolean DUMP_TRANSFORMATION = Tweaks.getBooleanProperty("firstCall.dumpTransformations", false);
    public static final String DUMP_TRANSFORMATION_DIRECTORY = Tweaks.getStringProperty("firstCall.dumpDirectory", "./dump/");
    public static final boolean BYPASS = Tweaks.getBooleanProperty("firstCall.bypass", false);
    public static final String KEYMANAGER_FACTORY = Tweaks.getStringProperty("client.connection.keymanagerFactory", "NewSunX509,SunX509,default");
    public static final boolean DEBUG_SAFEGUARDS = Tweaks.getBooleanProperty("safeguards.debug", false);
    public static final boolean VM_DISCONNECT_ALLOWED = Tweaks.getBooleanProperty("safeguards.vmDisconnectEventAllowed", true);
    public static final boolean HEARTBEAT_ENABLE = Tweaks.getBooleanProperty("heartbeat.enable", false);

    private static boolean getBooleanPropertyDeprecated(String prop, boolean defaultVal) {
        boolean value = Tweaks.getBooleanProperty(prop, defaultVal);
        if (Tweaks.isPropertySet(prop)) {
            System.err.println("WARNING: CRS property is deprecated " + prop + "=" + value);
        }
        return value;
    }

    private static boolean getBooleanProperty(String prop, boolean defaultVal) {
        return Boolean.parseBoolean(Tweaks.getStringProperty(prop, Objects.toString(defaultVal)));
    }

    private static int getIntPropertyDeprecated(String prop, int defaultVal) {
        int value = Tweaks.getIntProperty(prop, defaultVal);
        if (Tweaks.isPropertySet(prop)) {
            System.err.println("WARNING: CRS property is deprecated " + prop + "=" + value);
        }
        return value;
    }

    private static int getIntProperty(String prop, int defaultVal) {
        return Integer.parseInt(Tweaks.getStringProperty(prop, Objects.toString(defaultVal)));
    }

    private static boolean isPropertySet(String prop) {
        String propFullKeyString = PACKAGE_PREFIX + prop;
        try {
            return null != System.getProperty(propFullKeyString);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static String getStringProperty(String prop, String defaultVal) {
        try {
            String propFullKeyString = PACKAGE_PREFIX + prop;
            String value = System.getProperty(propFullKeyString, defaultVal);
            if (value != defaultVal) {
                allProperties.add(propFullKeyString);
            }
            return value;
        }
        catch (SecurityException ex) {
            if (FORCE_TRACE_LOGGING) {
                System.err.println("WARNING: CRS using default property value " + PACKAGE_PREFIX + prop + "=" + defaultVal + " due to JVM security policies");
            }
            return defaultVal;
        }
    }

    public static void dump(Consumer<String> logger) {
        for (String key : new HashSet<String>(allProperties)) {
            String value = System.getProperty(key);
            if (value == null) continue;
            logger.accept(key);
        }
        allProperties.clear();
    }
}

