/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client;

import com.azul.crs.javaagent.json.JSONSerializer;
import com.azul.crs.javaagent.json.JSONStaticSerializer;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class);
    private static final char[] digit = "0123456789abcdef".toCharArray();
    public static final JSONSerializer serializer = new JSONStaticSerializer();
    public static final JSONSerializer prettySerializer = new JSONStaticSerializer(true);
    public static final int BUFFER_SIZE = 8192;
    private static final ThreadLocal<WeakReference<byte[]>> buffers = new ThreadLocal();

    private Utils() {
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(String value) {
        return UUID.nameUUIDFromBytes(value.getBytes()).toString();
    }

    public static String uuid(Object ... values) {
        return Utils.uuid(Arrays.toString(values));
    }

    public static String lower(String s) {
        return s != null ? s.toLowerCase() : null;
    }

    public static long currentTimeCount() {
        return System.nanoTime();
    }

    public static long nextTimeCount(long timeoutMillis) {
        return System.nanoTime() + timeoutMillis * 1000000L;
    }

    public static String elapsedTimeString(long startTimeStamp) {
        return String.format(" (%,d ms)", Utils.elapsedTimeMillis(startTimeStamp));
    }

    public static long elapsedTimeMillis(long startTimeCount) {
        return (System.nanoTime() - startTimeCount + 500000L) / 1000000L;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String encodeToStringOrNull(byte[] hash, int off, int len) {
        if (null == hash) {
            return null;
        }
        char[] str = new char[len * 2];
        for (int i = off; i < off + len; ++i) {
            byte b = hash[i];
            str[(i - off) * 2] = digit[b >>> 4 & 0xF];
            str[(i - off) * 2 + 1] = digit[b & 0xF];
        }
        return new String(str);
    }

    public static String encodeToStringOrNull(byte[] hash) {
        if (null == hash) {
            return null;
        }
        return Utils.encodeToStringOrNull(hash, 0, hash.length);
    }

    @Deprecated
    public static void transfer(InputStream is, OutputStream output) throws IOException {
        int read;
        byte[] buffer;
        WeakReference<byte[]> ref = buffers.get();
        if (ref == null || (buffer = (byte[])ref.get()) == null) {
            buffer = new byte[8192];
            buffers.set(new WeakReference<byte[]>(buffer));
        }
        while ((read = is.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, read);
        }
    }

    public static final class Deadline {
        private final long deadline;
        private volatile boolean expired = false;

        private Deadline(long deadline) {
            this.deadline = deadline;
        }

        public static Deadline in(long time, TimeUnit units) {
            if (time < 0L) {
                throw new IllegalArgumentException("Can setup deadline in the future only");
            }
            return new Deadline(System.nanoTime() + units.toNanos(time));
        }

        public static boolean hasExpired(Deadline deadline) {
            return deadline != null && deadline.hasExpired();
        }

        public boolean hasExpired() {
            this.remainder(TimeUnit.NANOSECONDS);
            return this.expired;
        }

        public long remainder(TimeUnit timeUnit) {
            if (this.expired) {
                return 0L;
            }
            long nanosecondsBeforeDeadline = Math.max(0L, this.deadline - System.nanoTime());
            if (nanosecondsBeforeDeadline == 0L) {
                this.expired = true;
                return 0L;
            }
            return timeUnit.convert(nanosecondsBeforeDeadline, TimeUnit.NANOSECONDS);
        }

        public <R, E extends Exception> Optional<R> applyIfNotExpired(TimeLimitedFunction<R, E> function) throws E {
            long reminder = this.remainder(TimeUnit.MILLISECONDS);
            return reminder > 0L ? Optional.ofNullable(function.apply(reminder)) : Optional.empty();
        }

        public <E extends Exception> void runIfNotExpired(TimeLimitedRunnable<E> action) throws E {
            long reminder = this.remainder(TimeUnit.MILLISECONDS);
            if (reminder > 0L) {
                action.run(reminder);
            }
        }

        @FunctionalInterface
        public static interface TimeLimitedRunnable<E extends Exception> {
            public void run(long var1) throws E;
        }

        @FunctionalInterface
        public static interface TimeLimitedFunction<R, E extends Exception> {
            public R apply(long var1) throws E;
        }
    }

    public static final class CountingOutputStream
    extends FilterOutputStream {
        private final Consumer<Long> onClose;
        private long counter = 0L;

        public CountingOutputStream(OutputStream orig, Consumer<Long> onClose) {
            super(orig);
            this.onClose = onClose;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.counter += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.counter;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.onClose.accept(this.counter);
        }
    }

    public static final class Digest {
        private static final int MAC_POOL_SIZE = 2;
        private static volatile BlockingQueue<Mac> macPool = null;
        private static final String DIGEST_ALGO = "HmacSHA256";
        private static final Object lock = new Object();
        private static boolean macPoolInitialized = false;

        private Digest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Mac acquireMAC() throws InterruptedException {
            BlockingQueue<Mac> pool = macPool;
            if (pool == null) {
                Object object = lock;
                synchronized (object) {
                    pool = macPool;
                    if (pool == null && !macPoolInitialized) {
                        macPoolInitialized = true;
                        ArrayBlockingQueue<Mac> p = new ArrayBlockingQueue<Mac>(2);
                        byte[] secret = new byte[256];
                        new SecureRandom().nextBytes(secret);
                        SecretKeySpec secretKeySpec = new SecretKeySpec(secret, DIGEST_ALGO);
                        for (int i = 0; i < 2; ++i) {
                            try {
                                Mac mac = Mac.getInstance(DIGEST_ALGO);
                                if (mac == null) {
                                    logger.error("Unable to instantiate MAC for %s", DIGEST_ALGO);
                                    return null;
                                }
                                mac.init(secretKeySpec);
                                p.put(mac);
                                continue;
                            }
                            catch (InvalidKeyException | NoSuchAlgorithmException ex) {
                                logger.error("Unable to instantiate MAC for %s", DIGEST_ALGO);
                                return null;
                            }
                        }
                        macPool = p;
                        pool = p;
                    }
                }
            }
            return pool == null ? null : pool.take();
        }

        private static void releaseMAC(Mac mac) throws InterruptedException {
            BlockingQueue<Mac> pool = macPool;
            if (pool != null) {
                mac.reset();
                pool.put(mac);
            }
        }

        public static byte[] digest(byte[] bytes) {
            byte[] result;
            block5: {
                result = null;
                try {
                    Mac mac = Digest.acquireMAC();
                    if (mac == null) break block5;
                    try {
                        result = mac.doFinal(bytes);
                    }
                    finally {
                        Digest.releaseMAC(mac);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            }
            return result;
        }

        public static String digestBase64(String data) {
            byte[] digest = Digest.digest(data.getBytes());
            return digest == null ? null : Base64.getEncoder().encodeToString(digest);
        }
    }
}

