/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.agent;

import com.azul.crs.javaagent.client.utils.VersionHelper;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;

public class ChainContext {
    public final int classId;
    public final Instrumentation instrumentation;
    public final int classVersion;
    public final ClassLoader classLoader;
    public final String className;
    public final Class<?> classBeingRedefined;
    public final ProtectionDomain protectionDomain;
    public final byte[] origin;
    public Class mirror;
    public int patchingResult;
    public Throwable patchingFailedCause;
    private static AtomicInteger classIdCounter = new AtomicInteger();

    ChainContext(int classId, Instrumentation instrumentation, int classVersion, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] origin) {
        this.classId = classId;
        this.instrumentation = instrumentation;
        this.classVersion = classVersion;
        this.classLoader = classLoader;
        this.className = className;
        this.classBeingRedefined = classBeingRedefined;
        this.protectionDomain = protectionDomain;
        this.origin = origin;
    }

    public void setMirrorClass(Class mirror) {
        this.mirror = mirror;
    }

    public void setPatchingResult(int patchingResult, Throwable cause) {
        this.patchingResult = patchingResult;
        this.patchingFailedCause = cause;
    }

    public void setPatchingResultUnexpected() {
        this.setPatchingResult(-1);
    }

    public void setPatchingResultNoAdaptersApplied() {
        this.setPatchingResult(1);
    }

    public void setPatchingResult(int patchingResult) {
        this.setPatchingResult(patchingResult, null);
    }

    public String toString() {
        return "ChainContext[classId=" + this.classId + ", classVersion=" + this.classVersion + ", classLoader=" + this.classLoader + ", className=" + this.className + ", protectionDomain=" + this.protectionDomain + ", mirror=" + this.mirror + ", patchingResult=" + this.patchingResult + ", patchingFailedCause=" + this.patchingFailedCause + "]";
    }

    public static ChainContextBuilder contextFactory(Instrumentation instrumentation) {
        return new ChainContextBuilder(instrumentation);
    }

    public static class ChainContextBuilder {
        private final Instrumentation instrumentation;

        public ChainContextBuilder(Instrumentation instrumentation) {
            this.instrumentation = instrumentation;
        }

        public ChainContext create(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
            int classVersion = VersionHelper.getClassFileVersion(classFileBuffer);
            return new ChainContext(classIdCounter.getAndIncrement(), this.instrumentation, classVersion, loader, className, classBeingRedefined, protectionDomain, classFileBuffer);
        }
    }
}

