/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.agent;

import com.azul.crs.javaagent.client.agent.ChainContext;
import com.azul.crs.javaagent.client.agent.Transformer;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ChainTransformer
implements ClassFileTransformer {
    static Logger logger = Logger.getLogger(ChainTransformer.class);
    private final ChainContext.ChainContextBuilder contextProvider;
    private final Transformer[] transformers;

    private ChainTransformer(ChainContext.ChainContextBuilder contextProvider, Transformer ... transformers) {
        this.contextProvider = contextProvider;
        this.transformers = Arrays.stream(transformers).filter(t -> null != t).collect(Collectors.toList()).toArray(new Transformer[0]);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] original = classfileBuffer;
        ChainContext context = this.contextProvider.create(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        for (Transformer transformer : this.transformers) {
            if (transformer == null) continue;
            try {
                classfileBuffer = transformer.transform(classfileBuffer, context);
            }
            catch (Throwable t) {
                logger.warning("transformation of class=%s failed with exception: %s", className, t);
                classfileBuffer = original;
            }
        }
        return classfileBuffer;
    }

    public static ChainTransformer getInstance(ChainContext.ChainContextBuilder contextProvider, Transformer ... transformers) {
        if (contextProvider == null) {
            logger.error("ChainTransformer cannot be instantiated without context builder", new Object[0]);
            return null;
        }
        if (transformers == null || transformers.length == 0 || Arrays.stream(transformers).allMatch(t -> t == null)) {
            logger.debug("No need to create ChainTransformer if there is no delegates", new Object[0]);
            return null;
        }
        return new ChainTransformer(contextProvider, transformers);
    }
}

