/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.agent;

import com.azul.crs.javaagent.client.Inventory;
import com.azul.crs.javaagent.client.agent.MainMethodDetectionInterface;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MainMethodDetection
implements MainMethodDetectionInterface {
    private static Logger logger = Logger.getLogger(MainMethodDetection.class);
    private static final String MAIN_METHOD_NAME = ".main";
    private final Set<String> ignoreFilter = new HashSet<String>();
    private boolean found = false;
    private final VmEventConsumer eventConsumer;

    public MainMethodDetection(VmEventConsumer eventConsumer) {
        this.eventConsumer = eventConsumer;
        this.initIgnoreFilter();
    }

    private void initIgnoreFilter() {
        this.ignoreFilter.add("com/azul/crs/javaagent");
        this.ignoreFilter.add("sun/");
        this.ignoreFilter.add("com/sun/");
        this.ignoreFilter.add("jdk/internal");
        this.ignoreFilter.add("java/");
    }

    @Override
    public void detect(String className, ClassLoader classLoader) {
        if (this.found) {
            return;
        }
        boolean ignored = false;
        for (String ignorePackage : this.ignoreFilter) {
            if (!className.startsWith(ignorePackage)) continue;
            ignored = true;
            break;
        }
        if (!ignored && this.hasMainMethod(className, classLoader)) {
            this.found = true;
            logger.debug("main method in class: " + className, new Object[0]);
            this.notifyMainClass(className);
        }
    }

    private void notifyMainClass(String className) {
        Map<String, Object> inventory = new Inventory().mainMethod(className + MAIN_METHOD_NAME).toMap();
        this.eventConsumer.patchInventory(inventory);
    }

    private boolean hasMainMethod(String className, ClassLoader classLoader) {
        Class<?> c;
        String nn = className.replaceAll("/", ".");
        try {
            c = this.loadClass(nn, classLoader);
        }
        catch (Throwable t) {
            logger.debug("Runtime exception during the looking for main method in " + className, t);
            return false;
        }
        if (c == null) {
            logger.info("Main method detection: can not load the class " + className, new Object[0]);
            return false;
        }
        try {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = c.getDeclaredMethods()) {
                if (!declaredMethod.getName().equals("main") || !Modifier.isStatic(declaredMethod.getModifiers())) continue;
                return true;
            }
        }
        catch (NoClassDefFoundError error) {
            logger.debug("Main method detection: can not scan the class %s for main method.", className);
        }
        catch (SecurityException e) {
            logger.debug("Exception during the looking for main method in " + className, e);
        }
        catch (Throwable t) {
            logger.debug("Runtime exception during the looking for main method in " + className, t);
        }
        return false;
    }

    private Class<?> loadClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable2) {
                return null;
            }
        }
    }
}

