/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.classLoad;

import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.agent.ChainContext;
import com.azul.crs.javaagent.client.agent.Transformer;
import com.azul.crs.javaagent.client.classLoad.ClassLoadMessage;
import com.azul.crs.javaagent.client.service.MessageQueueServiceInterface;
import com.azul.crs.javaagent.util.logging.Logger;

public class ClassLoadReportingTransformer
implements Transformer {
    static Logger logger = Logger.getLogger(ClassLoadReportingTransformer.class);
    private final MessageQueueServiceInterface messageQueue;

    private ClassLoadReportingTransformer(MessageQueueServiceInterface messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public byte[] transform(byte[] classfileBuffer, ChainContext context) {
        if (context.classLoader != null && context.className != null) {
            this.messageQueue.notifyWith(new ClassLoadMessage(context.classLoader, context.className, context.classBeingRedefined, context.protectionDomain, context.origin, context.classId, context.patchingResult));
        }
        return classfileBuffer;
    }

    public static ClassLoadReportingTransformer getInstance(MessageQueueServiceInterface messageQueue) {
        if (!Options.notifyClassLoad.isYes() && !Options.notifyJarLoad.isYes()) {
            return null;
        }
        if (messageQueue == null) {
            logger.warning("Instantiating of ClassLoadReportingTransformer is not allowed without EventQueue", new Object[0]);
            return null;
        }
        return new ClassLoadReportingTransformer(messageQueue);
    }
}

