/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.classLoad;

import com.azul.crs.javaagent.client.classLoad.JDKClassloaderHandler;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassLoaderWrapper {
    private static final Logger logger = Logger.getLogger(ClassLoaderWrapper.class);
    private final int hash;
    private final WeakReference<ClassLoader> cl_ref;
    public boolean isVisited;
    public boolean isHandled;

    public ClassLoaderWrapper(ClassLoader cl) {
        this.hash = cl.hashCode();
        this.cl_ref = new WeakReference<ClassLoader>(cl);
    }

    public URL[] getURLs() {
        this.isVisited = true;
        ClassLoader cl = (ClassLoader)this.cl_ref.get();
        if (cl == null) {
            logger.warning("Classloader already was collected by GC", new Object[0]);
            this.isHandled = true;
            return null;
        }
        if (cl instanceof URLClassLoader) {
            return ((URLClassLoader)cl).getURLs();
        }
        String classLoaderName = cl.getClass().getName();
        if (classLoaderName == null) {
            return null;
        }
        if (classLoaderName.equals("jdk.internal.loader.BuiltinClassLoader") || classLoaderName.equals("java.net.URLClassLoader") || classLoaderName.startsWith("jdk.internal.loader.ClassLoaders") || classLoaderName.startsWith("java.net.FactoryURLClassLoader")) {
            this.isHandled = true;
            return JDKClassloaderHandler.parseURLS(cl);
        }
        if (classLoaderName.equals("jdk.internal.reflect.DelegatingClassLoader") || classLoaderName.equals("sun.reflect.DelegatingClassLoader")) {
            this.isHandled = true;
            logger.debug("Filtered out useless DelegatingClassLoader", new Object[0]);
            return null;
        }
        logger.debug("Unable to find corresponding ClassLoaderHandler for the ClassLoader:  " + cl.getClass().getName(), new Object[0]);
        return null;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        ClassLoader classLoader = (ClassLoader)this.cl_ref.get();
        if (obj == null || this.getClass() != obj.getClass() || classLoader == null) {
            return false;
        }
        return classLoader.equals(((ClassLoaderWrapper)obj).cl_ref.get());
    }
}

