/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.classLoad;

import com.azul.crs.javaagent.client.classLoad.ClassLoaderWrapper;
import com.azul.crs.javaagent.client.utils.VersionHelper;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.URL;
import java.net.URLClassLoader;

public class JDKClassloaderHandler {
    private static final Logger logger = Logger.getLogger(ClassLoaderWrapper.class);

    public static URL[] parseURLS(ClassLoader cl) {
        if (VersionHelper.JAVA_MAJOR_VERSION < 9) {
            logger.info("Going to use pre-module path of extracting URLs", new Object[0]);
            return JDKClassloaderHandler.extractPre9Classloader(cl);
        }
        logger.info("Going to use 9+ path of extracting URLs", new Object[0]);
        return JDKClassloaderHandler.extract9PlusClassloader(cl);
    }

    private static URL[] extractPre9Classloader(ClassLoader cl) {
        return ((URLClassLoader)cl).getURLs();
    }

    private static URL[] extract9PlusClassloader(ClassLoader cl) {
        URL[] urls = null;
        try {
            if (cl instanceof URLClassLoader) {
                logger.info("Detected  URLClassLoader", new Object[0]);
                return ((URLClassLoader)cl).getURLs();
            }
        }
        catch (Exception e) {
            logger.error("Could not obtain classpath URLs in Java 9+ - Exception was: %s", e.getLocalizedMessage(), e);
        }
        return urls;
    }
}

