/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.eventconsumer;

import com.azul.crs.javaagent.client.Client;
import com.azul.crs.javaagent.client.PerformanceMetrics;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.Version;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.models.VMArtifact;
import com.azul.crs.javaagent.client.models.VMArtifactChunk;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.models.VMInstance;
import com.azul.crs.javaagent.client.service.DataWriter;
import com.azul.crs.javaagent.client.service.EventService;
import com.azul.crs.javaagent.client.service.UploadService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PostVmData
implements VmEventConsumer {
    private final String revision;
    private final String version;
    private final String owner;
    private final EventService eventService;
    private final UploadService uploadService;
    private final AtomicInteger nextArtifactId = new AtomicInteger();

    public PostVmData(Client client) {
        Version version = new Version();
        this.revision = version.clientRevision();
        this.version = version.clientVersion();
        this.owner = client.getConnectionManager().getMailbox();
        this.eventService = client.getEventService();
        this.uploadService = client.getUploadService();
    }

    @Override
    public void consumeVMStart(Map<String, Object> inventory, Map<String, String> crsArgs, long startTime) {
        VMEvent event = new VMEvent().eventType(VMEvent.Type.VM_CREATE).eventPayload(new VMInstance().agentVersion(this.version).agentRevision(this.revision).owner(this.owner).inventory(inventory).crsArgs(crsArgs).startTime(startTime));
        this.eventService.addVmStart(event.randomEventId());
    }

    @Override
    public void patchInventory(Map<String, Object> inventory) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_PATCH).eventPayload(new VMInstance().inventory(inventory)));
    }

    @Override
    public void consumeVMEvent(VMEvent event) {
        this.eventService.add(event.randomEventId());
    }

    @Override
    public void consumeVMShutdown(Collection<VMEvent> trailingEvents) {
        this.eventService.addAll(trailingEvents);
        this.eventService.add(new VMEvent().randomEventId().eventType(VMEvent.Type.VM_SHUTDOWN).eventTime(Utils.currentTimeMillis()));
    }

    @Override
    public void consumeVMDisconnectedSynchronously(VMEvent event) {
        this.eventService.sendSynchronously(event);
    }

    @Override
    public int createArtifactId() {
        return this.nextArtifactId.incrementAndGet();
    }

    private void consumeVMArtifactCreate(VMArtifact.Type type, int artifactId, Map<String, Object> attributes, DataWriter dataWriter) {
        VMEvent event = new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_CREATE).eventPayload(new VMArtifact().artifactType(type).artifactId(this.artifactIdToString(artifactId)).metadata(attributes));
        if (dataWriter != null) {
            event.onError(() -> dataWriter.handleException(new RuntimeException("canceled")));
        }
        this.consumeVMEvent(event);
    }

    @Override
    public void consumeVMArtifactCreate(VMArtifact.Type type, int artifactId, Map<String, Object> attributes) {
        this.consumeVMArtifactCreate(type, artifactId, attributes, null);
    }

    @Override
    public void consumeVMArtifactData(Integer artifactId, String data) {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("artifactId", this.artifactIdToString(artifactId));
        payload.put("data", data);
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_DATA).eventPayload(payload));
        PerformanceMetrics.logArtifactBytes(data.length());
    }

    @Override
    public void consumeVMArtifact(VMArtifact.Type type, int artifactId, Map<String, Object> attributes, DataWriter dataWriter) {
        this.consumeVMArtifactCreate(type, artifactId, attributes, dataWriter);
        this.consumeVMArtifactChunk(type, Collections.singleton(artifactId), Collections.emptyMap(), dataWriter);
    }

    @Override
    public String artifactIdToString(int artifactId) {
        return Integer.toString(artifactId, 36);
    }

    @Override
    public void consumeVMArtifactChunk(VMArtifact.Type artifactType, Set<Integer> artifactIds, Map<String, Object> attributes, DataWriter dataWriter) {
        HashSet<String> ids = new HashSet<String>();
        artifactIds.forEach(id -> ids.add(this.artifactIdToString((int)id)));
        this.uploadService.post(new VMArtifactChunk().artifactIds(ids).metadata(attributes).artifactType(artifactType), dataWriter);
    }

    @Override
    public void finishVmArtifactChunk() {
        this.uploadService.sync();
    }

    @Override
    public void consumeVMArtifactPatch(VMArtifact.Type type, int artifactId, Map<String, Object> attributes) {
        this.consumeVMEvent(new VMEvent().eventType(VMEvent.Type.VM_ARTIFACT_PATCH).eventPayload(new VMArtifact().artifactType(type).artifactId(this.artifactIdToString(artifactId)).metadata(attributes)));
    }
}

