/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.featureflags;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FeatureFlags {
    JVMI(new Definition[0]),
    AVD(new Definition[]{Definition.notifyJarLoad, Definition.notifyClassLoad}),
    CI(new Definition[]{Definition.notifyJarLoad, Definition.notifyClassLoad, Definition.notifyFirstCall, Definition.notifyClassMethods}),
    ALL(new Definition[]{Definition.notifyFirstCall, Definition.notifyClassMethods, Definition.notifyClassLoad, Definition.notifyJarLoad});

    private final Set<Definition> definition;

    private FeatureFlags(Definition[] definition) {
        this.definition = Stream.of(definition).collect(Collectors.toSet());
    }

    Set<Definition> getDefinition() {
        return this.definition;
    }

    static enum Definition {
        notifyJarLoad,
        notifyClassLoad,
        notifyFirstCall,
        notifyClassMethods;

    }
}

