/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.featureflags;

import com.azul.crs.javaagent.client.featureflags.FeatureFlags;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class FeatureFlagsConfiguration {
    private static final Logger logger = Logger.getLogger(FeatureFlagsConfiguration.class);
    private static AtomicBoolean notifyJarLoaded = new AtomicBoolean(false);
    private static AtomicBoolean notifyClassLoad = new AtomicBoolean(false);
    private static AtomicBoolean notifyFirstCall = new AtomicBoolean(false);
    private static AtomicBoolean notifyClassMethods = new AtomicBoolean(false);

    public static void initialize(boolean jarLoaded, boolean classLoad, boolean firstCall, boolean classMethods) {
        notifyJarLoaded = new AtomicBoolean(jarLoaded);
        notifyClassLoad = new AtomicBoolean(classLoad);
        notifyFirstCall = new AtomicBoolean(firstCall);
        notifyClassMethods = new AtomicBoolean(classMethods);
    }

    public static boolean notifyJarLoaded() {
        return notifyJarLoaded.get();
    }

    public static boolean notifyClassLoad() {
        return notifyClassLoad.get();
    }

    public static boolean notifyFirstCall() {
        return notifyFirstCall.get();
    }

    public static boolean notifyClassMethods() {
        return notifyClassMethods.get();
    }

    static List<FeatureFlags> update(Set<FeatureFlags> flags) {
        HashSet<FeatureFlags.Definition> notNeeded = new HashSet<FeatureFlags.Definition>(FeatureFlags.ALL.getDefinition());
        flags.forEach(flag -> notNeeded.removeAll(flag.getDefinition()));
        notNeeded.forEach(d -> FeatureFlagsConfiguration.getOption(d).set(false));
        return FeatureFlagsConfiguration.checkIntegrity(flags);
    }

    public static List<FeatureFlags> updateFeatureFlags(Collection<String> lines) {
        String keyword = "features=";
        Set<FeatureFlags> featureFlags = lines.stream().filter(line -> {
            if (line.startsWith(keyword)) {
                return true;
            }
            logger.info("Feature flags configuration contains the invalid line: %s. It will be ignored", line);
            return false;
        }).flatMap(line -> Arrays.stream(line.replace(keyword, "").split("\\+"))).map(one -> FeatureFlags.valueOf(one)).collect(Collectors.toSet());
        if (!featureFlags.isEmpty()) {
            List<FeatureFlags> integrity = FeatureFlagsConfiguration.update(featureFlags);
            integrity.forEach(flag -> logger.info("Feature flag: %s allowed by IC, but an Option is disabled locally.", flag));
            return integrity;
        }
        return Collections.emptyList();
    }

    private static AtomicBoolean getOption(FeatureFlags.Definition definition) {
        switch (definition) {
            case notifyJarLoad: {
                return notifyJarLoaded;
            }
            case notifyClassLoad: {
                return notifyClassLoad;
            }
            case notifyClassMethods: {
                return notifyClassMethods;
            }
            case notifyFirstCall: {
                return notifyFirstCall;
            }
        }
        throw new RuntimeException("Unknown definition: " + (Object)((Object)definition));
    }

    private static List<FeatureFlags> checkIntegrity(Set<FeatureFlags> flags) {
        ArrayList<FeatureFlags> failedFlags = new ArrayList<FeatureFlags>();
        for (FeatureFlags flag : flags) {
            if (flag.getDefinition().stream().allMatch(definition -> FeatureFlagsConfiguration.getOption(definition).get())) continue;
            failedFlags.add(flag);
        }
        return failedFlags;
    }

    public static boolean isEnabled(VMEvent.Type eventType) {
        switch (eventType) {
            case VM_CLASS_LOADED: {
                return notifyClassLoad.get();
            }
            case VM_METHOD_FIRST_CALLED: {
                return notifyFirstCall.get();
            }
            case VM_JAR_LOADED: {
                return notifyJarLoaded.get();
            }
        }
        return true;
    }
}

