/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.firstCall;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.firstCall.ClassVisitorParams;
import com.azul.crs.javaagent.client.firstCall.MethodVisitorParams;
import com.azul.crs.javaagent.client.firstCall.TransformationAdapter;
import com.azul.crs.javaagent.client.utils.VersionHelper;
import com.azul.crs.javaagent.internal.asm.ClassVisitor;
import com.azul.crs.javaagent.internal.asm.FieldVisitor;
import com.azul.crs.javaagent.internal.asm.MethodVisitor;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultClassVisitor
extends ClassVisitor {
    private static final Logger logger = Logger.getLogger(TransformationAdapter.class);
    final ClassVisitorParams params;
    private final Set<FieldDescriptor> newFields = new HashSet<FieldDescriptor>();

    DefaultClassVisitor(ClassVisitorParams params) {
        super(params.api, params.delegate);
        this.params = params;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(VersionHelper.normalizeClassVersion(version) < VersionHelper.normalizeClassVersion(this.params.transformationAdapter.classFileVersionAfterTransformation) ? this.params.transformationAdapter.classFileVersionAfterTransformation : version, access, name, signature, superName, interfaces);
        this.cv.visitEnd();
    }

    public void addStaticField(int access, String name, String descriptor, String signature, Object value) {
        this.newFields.add(new FieldDescriptor(access, name, descriptor, signature, value));
    }

    public void addStaticField(String name, Object value) {
        this.addStaticField(10, name, "Ljava/lang/Object;", null, value);
    }

    public void addStaticField(String name) {
        this.addStaticField(name, null);
    }

    @Override
    public void visitEnd() {
        for (FieldDescriptor f : this.newFields) {
            FieldVisitor fv = this.cv.visitField(f.access, f.name, f.descriptor, f.signature, f.value);
            fv.visitEnd();
        }
        this.cv.visitEnd();
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor delegate = this.cv.visitMethod(access, methodName, desc, signature, exceptions);
        if (Tweaks.DEBUG_FIRST_CALLS) {
            logger.trace("visitMethod: %d, %s, %s, %s, %s", access, methodName, desc, signature, exceptions == null ? "null" : "[" + Arrays.stream(exceptions).collect(Collectors.joining(", ")) + "]");
        }
        if (0 != (access & 0x500)) {
            return delegate;
        }
        if (this.params.transformationAdapter.staticInitializerVisitorSupplier != null && "<clinit>".equals(methodName)) {
            delegate = this.params.transformationAdapter.staticInitializerVisitorSupplier.apply(new MethodVisitorParams(this.params.api, delegate, this, access, methodName, desc, signature, exceptions));
        }
        MethodVisitor mv = this.params.transformationAdapter.methodVisitorSupplier.apply(new MethodVisitorParams(this.params.api, delegate, this, access, methodName, desc, signature, exceptions));
        return mv;
    }

    private static final class FieldDescriptor {
        final int access;
        final String name;
        final String descriptor;
        final String signature;
        final Object value;

        private FieldDescriptor(int access, String name, String descriptor, String signature, Object value) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.value = value;
        }
    }
}

