/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.firstCall;

import com.azul.crs.javaagent.client.firstCall.FirstCallReportingTransformer;
import com.azul.crs.javaagent.client.utils.VersionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class DefineClassHelper {
    private static final Method defineClassMethod9plus;
    private static final Object unsafe;
    private static final Method defineClassMethod8;
    private static final Object javaLangAccess;
    private static final Throwable cause;
    public static final boolean initialized;

    public static Class defineClass(ClassLoader classLoader, ProtectionDomain protectionDomain, String name, byte[] bytes) {
        if (!initialized) {
            throw new DefineClassHelperIsNotInitializedException(cause);
        }
        try {
            Class c = null;
            c = VersionHelper.JAVA_MAJOR_VERSION >= 9 ? (Class)defineClassMethod9plus.invoke(javaLangAccess, classLoader, name, bytes, protectionDomain, "__Lookup_defineClass__") : (Class)defineClassMethod8.invoke(unsafe, name, bytes, 0, bytes.length, classLoader, protectionDomain);
            FirstCallReportingTransformer.dumpClassFile("generated", name, bytes);
            return c;
        }
        catch (Exception e) {
            throw new FailedToDefineClassException("rethrow", e);
        }
    }

    static {
        Method defineClassMethod9plusLocal = null;
        Object unsafeLocal = null;
        Method defineClassMethod8Local = null;
        Object javaLangAccessLocal = null;
        Throwable causeLocal = null;
        boolean initializedLocal = false;
        try {
            if (VersionHelper.JAVA_MAJOR_VERSION >= 9) {
                Class<?> sharedSecrets = null;
                try {
                    sharedSecrets = Class.forName("jdk.internal.access.SharedSecrets");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (sharedSecrets == null) {
                    sharedSecrets = Class.forName("jdk.internal.misc.SharedSecrets");
                }
                javaLangAccessLocal = sharedSecrets.getMethod("getJavaLangAccess", new Class[0]).invoke(null, new Object[0]);
                defineClassMethod9plusLocal = javaLangAccessLocal.getClass().getMethod("defineClass", ClassLoader.class, String.class, byte[].class, ProtectionDomain.class, String.class);
                defineClassMethod9plusLocal.setAccessible(true);
            } else {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                unsafeLocal = theUnsafe.get(null);
                defineClassMethod8Local = unsafeLocal.getClass().getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            }
            initializedLocal = true;
        }
        catch (Throwable e) {
            causeLocal = e;
        }
        defineClassMethod9plus = defineClassMethod9plusLocal;
        unsafe = unsafeLocal;
        defineClassMethod8 = defineClassMethod8Local;
        javaLangAccess = javaLangAccessLocal;
        initialized = initializedLocal;
        cause = causeLocal;
    }

    public static class FailedToDefineClassException
    extends RuntimeException {
        FailedToDefineClassException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class DefineClassHelperIsNotInitializedException
    extends RuntimeException {
        DefineClassHelperIsNotInitializedException(Throwable cause) {
            super(cause);
        }
    }
}

