/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.firstCall;

import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.agent.ChainContext;
import com.azul.crs.javaagent.client.agent.Transformer;
import com.azul.crs.javaagent.client.firstCall.Adapters;
import com.azul.crs.javaagent.client.firstCall.MethodFirstCallListener;
import com.azul.crs.javaagent.client.firstCall.TransformationAdapter;
import com.azul.crs.javaagent.client.service.MessageQueueServiceInterface;
import com.azul.crs.javaagent.client.utils.VersionHelper;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.lang.instrument.IllegalClassFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Collectors;

public class FirstCallReportingTransformer
implements Transformer {
    private static final Logger logger = Logger.getLogger(FirstCallReportingTransformer.class);
    private static boolean processingExceptionNotSent = true;
    static final boolean aagentLoadedByBootstarpClassLoader;
    static final boolean methodFirstCallListenerAvailable;
    private final Transformer delegate;
    private static final boolean dumpTransformation;

    private FirstCallReportingTransformer(Transformer delegate) {
        this.delegate = delegate;
    }

    @Override
    public byte[] transform(byte[] classfileBuffer, ChainContext ctx) throws IllegalClassFormatException {
        if (Tweaks.BYPASS) {
            return classfileBuffer;
        }
        if (!methodFirstCallListenerAvailable) {
            return classfileBuffer;
        }
        try {
            if (ctx.className == null) {
                if (Tweaks.DEBUG_FIRST_CALLS) {
                    logger.trace("Skip system class from transformation: %s", ctx);
                }
                return classfileBuffer;
            }
            String prefix = "com/azul/crs/javaagent/".substring(0, 13);
            String className = ctx.className;
            if (ctx.classLoader == null || className.startsWith("java/") || className.startsWith("jdk/") || className.startsWith("com/sun/") || className.startsWith("sun/") || className.startsWith("javax/") || className.startsWith("com/azul/") && !className.startsWith(prefix + "testing/") || className.startsWith("azul/") || className.startsWith("apple/laf/") || className.startsWith("apple/security/") || className.startsWith("com/apple/eawt/") || className.startsWith("com/apple/eawt/event/") || className.startsWith("com/apple/eio/") || className.startsWith("com/apple/laf/") || className.startsWith("com/oracle/security/ucrypto/") || className.startsWith("com/fasterxml/") || className.startsWith("com/azul/crs/javaagent/internal/asm/") || className.startsWith("org/ietf/") || className.startsWith("org/jcp/") || className.startsWith("org/w3c/") || className.startsWith("org/xml/") || className.startsWith("azul/GENERATED/")) {
                if (Tweaks.DEBUG_FIRST_CALLS) {
                    logger.trace("Skip system class from transformation: %s", ctx);
                }
                return classfileBuffer;
            }
            if (Tweaks.DEBUG_FIRST_CALLS) {
                logger.trace("going to transform class for reporting first method calls later: %s", ctx);
            }
            FirstCallReportingTransformer.dumpClassFile("before", className, classfileBuffer);
            classfileBuffer = this.delegate.transform(classfileBuffer, ctx);
            FirstCallReportingTransformer.dumpClassFile("after", className, classfileBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return classfileBuffer;
    }

    public static void dumpClassFile(String prefix, String className, byte[] classfileBuffer) {
        if (Tweaks.DEBUG_FIRST_CALLS && dumpTransformation) {
            String directory0 = "<unset>";
            String directory1 = "<unset>";
            String classFile = "<unset>";
            String classDir = "<unset>";
            try {
                directory0 = Tweaks.DUMP_TRANSFORMATION_DIRECTORY + File.separator + prefix + File.separator;
                new File(directory0).mkdirs();
                classDir = new File(className).getParent();
                if (classDir != null) {
                    directory1 = directory0 + classDir + File.separator;
                    new File(directory1).mkdirs();
                }
                classFile = Tweaks.DUMP_TRANSFORMATION_DIRECTORY + File.separator + prefix + File.separator + new File(className + ".class").getPath();
                Files.write(Paths.get(classFile, new String[0]), classfileBuffer, new OpenOption[0]);
            }
            catch (Exception e) {
                logger.warning("Failed to dump class file %s transformation. base dir=%s, directory=%s, classFile=%s, classDir=%s, exception=%s", prefix, directory0, directory1, classFile, classDir, e);
            }
        }
    }

    static FirstCallReportingTransformer getInstance(MessageQueueServiceInterface eventQueue, String pipelineDescribingProperty) {
        if (!Options.notifyFirstCall.isYes()) {
            return null;
        }
        if (eventQueue == null) {
            logger.warning("Instantiating of FirstCallReportingTransformer is not allowed without EventQueue", new Object[0]);
            return null;
        }
        try {
            MethodFirstCallListener.init(eventQueue);
            TransformationAdapter[] adapters = Arrays.stream(pipelineDescribingProperty.split(",")).map(s -> {
                try {
                    return TYPE.valueOf(s).getAdapter();
                }
                catch (Exception e) {
                    logger.error("Failed to initialize adapter '%s' due to %s", s, e);
                    return null;
                }
            }).filter(t -> t != null && t.isSupportingJVM(VersionHelper.JAVA_MAJOR_VERSION)).collect(Collectors.toList()).toArray(new TransformationAdapter[0]);
            if (adapters.length == 0 || Arrays.stream(adapters).allMatch(ta -> ta == null)) {
                return null;
            }
            return new FirstCallReportingTransformer((bytes, ctx) -> {
                byte[] origin = bytes;
                for (TransformationAdapter adapter : adapters) {
                    if (bytes != origin) {
                        return bytes;
                    }
                    if (!adapter.canTransformClass(ctx)) continue;
                    try {
                        bytes = adapter.transform(bytes, ctx);
                    }
                    catch (Exception e) {
                        ctx.setPatchingResultUnexpected();
                        if (processingExceptionNotSent) {
                            logger.error("Adapter %s leaked exception %s during processing class %d", adapter.name, e, ctx.classId);
                            processingExceptionNotSent = false;
                        } else {
                            logger.debug("Adapter %s leaked exception %s during processing class %d", adapter.name, e, ctx.classId);
                        }
                        return origin;
                    }
                }
                if (bytes == origin && ctx.patchingResult == 0) {
                    logger.trace("No adapters were applied in order to report first method call events on class [id=%d], ctx: %s", ctx.classId, ctx);
                    ctx.setPatchingResultNoAdaptersApplied();
                }
                return bytes;
            });
        }
        catch (Throwable t2) {
            logger.error("Failed to instantiate FirstCallReportingTransformer due to errors %s", t2);
            return null;
        }
    }

    public static FirstCallReportingTransformer getInstance(MessageQueueServiceInterface messageQueue) {
        return FirstCallReportingTransformer.getInstance(messageQueue, Tweaks.FIRST_CALL_PROCESSING_CHAIN);
    }

    static {
        boolean res = false;
        boolean available = true;
        try {
            res = null == Class.forName("com.azul.crs.javaagent.client.firstCall.MethodFirstCallListener").getClassLoader();
        }
        catch (Exception e) {
            available = false;
            logger.error("Unexpected state of IC Agent: class MethodFirstCallListener expected to be defined in a-agent.jar: %s", e);
        }
        aagentLoadedByBootstarpClassLoader = res;
        methodFirstCallListenerAvailable = available;
        boolean dumpTransformation0 = false;
        if (Tweaks.DUMP_TRANSFORMATION) {
            try {
                if (!Files.isDirectory(Paths.get(Tweaks.DUMP_TRANSFORMATION_DIRECTORY, new String[0]), new LinkOption[0])) {
                    Files.createDirectories(Paths.get(Tweaks.DUMP_TRANSFORMATION_DIRECTORY, new String[0]), new FileAttribute[0]);
                }
                dumpTransformation0 = true;
            }
            catch (Exception e) {
                dumpTransformation0 = false;
                logger.warning("Disabling dump of transformed classes to directory='%s' due to exception: %s.", Tweaks.DUMP_TRANSFORMATION_DIRECTORY, e);
            }
        }
        dumpTransformation = dumpTransformation0;
    }

    private static enum TYPE {
        CONDY(Adapters.condy()),
        INDY(Adapters.indy()),
        MIRROR(Adapters.mirror());

        private final TransformationAdapter adapter;

        private TYPE(TransformationAdapter adapter) {
            this.adapter = adapter;
        }

        public TransformationAdapter getAdapter() {
            return this.adapter;
        }
    }
}

