/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.firstCall;

import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.firstCall.FirstMethodCallMessage;
import com.azul.crs.javaagent.client.service.MessageQueueServiceInterface;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class MethodFirstCallListener {
    public static final String methodListenerClassName = MethodFirstCallListener.class.getName().replace('.', '/');
    private static final Logger logger = Logger.getLogger(MethodFirstCallListener.class);
    private static AtomicLong methodsAmount = new AtomicLong();
    private static Set<String> methods = Collections.synchronizedSet(new HashSet());
    private static volatile MessageQueueServiceInterface aagentMessageQueue;

    public static void init(MessageQueueServiceInterface messageQueue) {
        aagentMessageQueue = messageQueue;
        if (Tweaks.DEBUG_FIRST_CALLS || Tweaks.PRINT_FIRST_METHODS) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.out.println("reported methods amount: " + methodsAmount.get());
                if (Tweaks.PRINT_FIRST_METHODS) {
                    for (String s : methods) {
                        System.out.println("method was called: " + s);
                    }
                }
            }));
        }
    }

    public static void notify(Long methodId, Integer classId, String methodNameAndDesc) {
        if (!Options.notifyFirstCall.isYes()) {
            return;
        }
        methodsAmount.incrementAndGet();
        FirstMethodCallMessage method = new FirstMethodCallMessage(classId, methodNameAndDesc);
        if (Tweaks.DEBUG_FIRST_CALLS) {
            logger.trace("notify: id=" + methodId + ", method=" + method, new Object[0]);
        }
        if (Tweaks.PRINT_FIRST_METHODS) {
            methods.add(method.name);
        }
        aagentMessageQueue.notifyWith(method);
    }

    public static Object report(MethodHandles.Lookup lookup, String name, Class c, Object ... args) {
        if (Tweaks.DEBUG_FIRST_CALLS) {
            logger.trace("report: lookup=" + lookup + ", name=" + name + ", class=" + c + ", args=[" + Arrays.stream(args).map(o -> Objects.toString(o)).collect(Collectors.joining(", ")) + "]", new Object[0]);
        }
        assert (args.length == 3);
        MethodFirstCallListener.notify((Long)args[0], (Integer)args[1], (String)args[2]);
        return "";
    }

    public static void emptyMethod() {
    }

    public static CallSite reportIndy(MethodHandles.Lookup lookup, String invokedName, MethodType invokedType, Object ... args) {
        if (Tweaks.DEBUG_FIRST_CALLS) {
            logger.trace("reportIndy: lookup=" + lookup + ", name=" + invokedName + ", type=" + invokedType + ", args=[" + Arrays.stream(args).map(o -> Objects.toString(o)).collect(Collectors.joining(", ")) + "]", new Object[0]);
        }
        try {
            assert (args.length == 3);
            MethodFirstCallListener.notify((Long)args[0], (Integer)args[1], (String)args[2]);
            return new ConstantCallSite(lookup.findStatic(MethodFirstCallListener.class, "emptyMethod", MethodType.methodType(Void.TYPE)));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

