/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.firstCall;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.agent.ChainContext;
import com.azul.crs.javaagent.client.agent.Transformer;
import com.azul.crs.javaagent.client.firstCall.ClassVisitorParams;
import com.azul.crs.javaagent.client.firstCall.DefaultClassVisitor;
import com.azul.crs.javaagent.client.firstCall.DefaultMethodVisitor;
import com.azul.crs.javaagent.client.firstCall.MethodVisitorParams;
import com.azul.crs.javaagent.client.utils.VersionHelper;
import com.azul.crs.javaagent.internal.asm.ClassReader;
import com.azul.crs.javaagent.internal.asm.ClassVisitor;
import com.azul.crs.javaagent.internal.asm.ClassWriter;
import com.azul.crs.javaagent.internal.asm.MethodVisitor;
import com.azul.crs.javaagent.util.logging.Logger;
import java.lang.instrument.IllegalClassFormatException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class TransformationAdapter
implements Transformer {
    static AtomicLong globalMethodCounter = new AtomicLong();
    public final String name;
    public final Function<ClassVisitorParams, DefaultClassVisitor> classVisitorSupplier;
    public final Function<MethodVisitorParams, DefaultMethodVisitor> methodVisitorSupplier;
    public final Function<MethodVisitorParams, DefaultMethodVisitor> staticInitializerVisitorSupplier;
    public final int classFileVersionAfterTransformation;
    public final int minimalSupportedClassFileVersion;
    public final int minimalSupportedJVMVersion;
    public final int adapterId;
    private static final Logger logger = Logger.getLogger(TransformationAdapter.class);

    public TransformationAdapter(String name, Function<ClassVisitorParams, DefaultClassVisitor> classVisitorSupplier, Function<MethodVisitorParams, DefaultMethodVisitor> methodVisitorSupplier, Function<MethodVisitorParams, DefaultMethodVisitor> staticInitializerVisitorSupplier, int classFileVersionAfterTransformation, int minimalSupportedClassFileVersion, int minimalSupportedJVMVersion, int adapterId) {
        this.name = name;
        this.classVisitorSupplier = classVisitorSupplier != null ? classVisitorSupplier : params -> new DefaultClassVisitor((ClassVisitorParams)params);
        this.methodVisitorSupplier = methodVisitorSupplier != null ? methodVisitorSupplier : params -> new DefaultMethodVisitor((MethodVisitorParams)params);
        this.staticInitializerVisitorSupplier = staticInitializerVisitorSupplier;
        this.classFileVersionAfterTransformation = classFileVersionAfterTransformation;
        this.minimalSupportedClassFileVersion = minimalSupportedClassFileVersion;
        this.minimalSupportedJVMVersion = minimalSupportedJVMVersion;
        this.adapterId = adapterId;
    }

    public final int getErrorState(Throwable e) {
        int result;
        int error;
        if (e == null) {
            return 0;
        }
        Object[] errors = new Object[]{NullPointerException.class, "com.azul.crs.javaagent.client.firstCall", "com.azul.crs.javaagent.internal.asm", "com.azul.crs.javaagent", RuntimeException.class};
        int adapterIdOffset = 2;
        int errorOffset = 4;
        for (error = 0; !(error >= errors.length || errors[error] instanceof String && e.getClass().getName().startsWith((String)errors[error]) || errors[error] instanceof Class && e.getClass().isInstance(errors[error])); ++error) {
        }
        if (error == errors.length) {
            return -1;
        }
        result = (result = this.adapterId << adapterIdOffset | ++error << errorOffset) == 0 || result == 1 ? -1 : result;
        return result;
    }

    public boolean isSupportingJVM(int javaMajorVersion) {
        boolean supports = javaMajorVersion >= this.minimalSupportedJVMVersion;
        logger.trace("Check if transformation adapter [%s] is applicable to JVM of version [%d] -- %s (minimal supported JVM version is %d)", this.name, javaMajorVersion, supports, this.minimalSupportedJVMVersion);
        return supports;
    }

    public boolean canTransformClass(ChainContext context) {
        boolean canRetransform = VersionHelper.normalizeClassVersion(context.classVersion) >= VersionHelper.normalizeClassVersion(this.minimalSupportedClassFileVersion);
        logger.trace("Check if transformation adapter [%s] can retransform class [id=%d,version=%d] -- %s (minimal supported class version is %d), ctx: %s", this.name, context.classId, context.classVersion, canRetransform, this.minimalSupportedClassFileVersion, context);
        return canRetransform;
    }

    public static String getFieldName(String name) {
        return "_fmc$" + name;
    }

    @Override
    public byte[] transform(byte[] classfileBuffer, ChainContext ctx) throws IllegalClassFormatException {
        if (Tweaks.DEBUG_FIRST_CALLS) {
            logger.trace("BaseAdapter.transform: [%s] %s", this.name, ctx);
        }
        final int[] classAccessFlags = new int[]{0};
        final int[] methodIdCounter = new int[1];
        final HashMap<String, Integer> methodIds = new HashMap<String, Integer>();
        try {
            new ClassReader(classfileBuffer).accept(new ClassVisitor(589824){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (0 != (access & 0x8000)) {
                        classAccessFlags[0] = access;
                        throw new SkipException();
                    }
                }

                @Override
                public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
                    int n = methodIdCounter[0];
                    methodIdCounter[0] = n + 1;
                    methodIds.put(methodName + desc, n);
                    return null;
                }
            }, 0);
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(0);
            ClassVisitor v = this.classVisitorSupplier.apply(new ClassVisitorParams(ctx.className, this, ctx, methodIds, 589824, cw));
            cr.accept(v, 0);
            cw.visitEnd();
            byte[] res = cw.toByteArray();
            return res;
        }
        catch (SkipException se) {
            if (Tweaks.DEBUG_FIRST_CALLS) {
                logger.trace("Skip synthetic class file [access flags == %d] from processing: %s", classAccessFlags[0], ctx);
            }
            return classfileBuffer;
        }
        catch (Throwable t) {
            ctx.setPatchingResult(this.getErrorState(t), t);
            return classfileBuffer;
        }
    }

    public static class SkipException
    extends RuntimeException {
    }
}

