/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ClassPathToSource {
    private static final Logger logger = Logger.getLogger(ClassPathToSource.class);

    public static List<String> process(String classPath) {
        return Arrays.stream(classPath.split(File.pathSeparator)).filter(s -> s.endsWith(".jar")).map(s -> {
            File f = new File((String)s);
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                logger.trace("Can not convert path=%s to canonical form e=%s", s, e.getMessage());
                return f.getAbsolutePath();
            }
        }).collect(Collectors.toList());
    }
}

