/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.JDKAccessor;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.jars.JarSource;
import com.azul.crs.javaagent.client.jars.VMEventHelper;
import com.azul.crs.javaagent.client.jars.tracker.JarTracker;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.safeguards.InsufficientMemoryException;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.util.JarAccessUtils;
import com.azul.crs.javaagent.client.util.ThrowingConsumer;
import com.azul.crs.javaagent.jar.ZipTools;
import com.azul.crs.javaagent.runtime.utils.ClassMethodsMap;
import com.azul.crs.javaagent.runtime.utils.DataEntriesMap;
import com.azul.crs.javaagent.runtime.utils.TempFilesFactory;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class JarAccess {
    private static boolean failedToCalculateDigestNotSent = true;
    final Logger logger = Logger.getLogger(this.getClass());
    private final ReferenceFactory referenceFactory;
    private final String source;
    private InitiatedBy initiatedBy;
    private final JarAccessUtils jarAccessUtils;
    private String hash;
    private ZipTools.JarShortDigest jarShortDigest;
    private Reference<JarEntry> jarEntry;
    private final Reference<JarFile> originJar;
    private final URL url;
    private String path;
    private Reference<JarFile> actualJar;
    private Reference<JarAccess> parent;
    private Reference<Cache> cache;
    private TempFilesFactory.TempFile tempFile;
    private final Reference<JarTracker> tracker;

    public TempFilesFactory.TempFile getTempFile() {
        return this.tempFile;
    }

    public JarAccess(ReferenceFactory referenceFactory, JarAccessUtils jarAccessUtils, JarFile jar, JarSource js, String path, InitiatedBy initiatedBy) {
        this(referenceFactory, jarAccessUtils, null, jar, js.getUrl(), path, js.getUrl().toString(), initiatedBy, null);
    }

    public JarAccess(ReferenceFactory referenceFactory, JarAccessUtils jarAccessUtils, JarAccess parent, JarFile jar, URL url, String path, String source, InitiatedBy initiatedBy, JarEntry jarEntry) {
        this.referenceFactory = referenceFactory;
        this.jarAccessUtils = jarAccessUtils;
        this.originJar = referenceFactory.createNewReference(jar);
        this.url = url;
        this.actualJar = referenceFactory.createNewReference(jar);
        this.path = path;
        this.source = source;
        this.initiatedBy = initiatedBy;
        this.parent = referenceFactory.createNewReference(parent);
        this.jarEntry = referenceFactory.createNewReference(jarEntry);
        this.tracker = referenceFactory.createNewReference(new JarTracker(jar, url, path));
        this.cache = referenceFactory.createNewReference(new Cache());
    }

    public void setInitiatedBy(InitiatedBy initiatedBy) {
        this.initiatedBy = initiatedBy;
    }

    public JarTracker getTracker() {
        return this.tracker.get();
    }

    public JarFile getJarFile() {
        return this.actualJar.get();
    }

    EntryAccess entryAccess() {
        if (this.jarEntry.get() == null) {
            return null;
        }
        return new EntryAccess();
    }

    public void withInputStream(ThrowingConsumer<InputStream, Exception> consumer) {
        if (this.entryAccess() != null) {
            this.entryAccess().withInputStream(consumer);
        } else {
            this.doWithJarReopen(j -> consumer.accept(null));
        }
    }

    public Long requiredTempfsSpace() {
        return this.jarEntry.get() == null ? 0L : this.entryAccess().getSize();
    }

    public String getManifesthash() {
        return this.jarShortDigest == null ? null : Utils.encodeToStringOrNull(this.jarShortDigest.getManifestHash());
    }

    public ZipTools.JarShortDigest getJarShortDigest() {
        if (this.jarShortDigest != null) {
            return this.jarShortDigest;
        }
        try {
            this.referenceFactory.oomSafeRun(() -> {
                this.jarShortDigest = this.jarAccessUtils.calculateJarShortDigest(this);
            });
        }
        catch (Exception e) {
            if (failedToCalculateDigestNotSent) {
                this.logger.error("Failed to calculate jarShortDigset for (%s) with exception: %s", this, e);
                failedToCalculateDigestNotSent = false;
            }
            this.logger.warning("Failed to calculate jarShortDigset for (%s) with exception: %s", this, e);
        }
        return this.jarShortDigest;
    }

    public JarAccess getParentJarAccess() {
        return this.parent.get();
    }

    public String getJarName() {
        return this.tempFile != null ? this.tempFile.getPath() : this.getUnifiedPath();
    }

    public String getUnifiedPath() {
        return !this.getPath().contains("!/") ? this.getPath() : "jar:file:" + this.getPath() + "!/";
    }

    public Cache getCache() {
        return this.cache.get();
    }

    public void acquireResources(TempFilesFactory.TempFile tempFile) throws IOException {
        this.getCache();
        this.tempFile = tempFile;
        if (this.jarEntry.get() != null) {
            this.path = tempFile.getAbsolutePath();
            this.referenceFactory.oomSafeRun(() -> this.withInputStream(is -> Files.copy(is, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING)));
            this.actualJar = this.referenceFactory.createNewReference(new JarFile((File)tempFile, false));
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getHashLazy() {
        return this.hash;
    }

    public String getHash() throws CentralDirectoryHashNotInitializedException {
        if (this.hash != null) {
            return this.hash;
        }
        this.doWithJarReopen(self -> {
            if (self == null || self.getJarShortDigest() == null) {
                throw new CentralDirectoryHashNotInitializedException("unexpected request: jarAccess=" + self + ", digest=" + (self != null ? self.getJarShortDigest() : null));
            }
            this.hash = Utils.encodeToStringOrNull(self.getJarShortDigest().getCentralDirectoryHash());
        });
        if (this.hash != null) {
            return this.hash;
        }
        throw new CentralDirectoryHashNotInitializedException("central directory hash not initialized yet.");
    }

    public URL getURL() {
        return this.url;
    }

    public String getSource() {
        return this.source;
    }

    public String getUrlOrSourceOrNull() {
        if (this.url != null) {
            return this.url.toString();
        }
        if (this.source != null) {
            return this.source.toString();
        }
        return null;
    }

    public void forEachJarEntry(ThrowingConsumer<JarAccess, Exception> consumer) {
        this.doWithJarReopen(self -> {
            for (JarEntry je : Collections.list(self.getJarFile().entries())) {
                if (!ZipTools.isJarFile(je.getName())) continue;
                JarAccess child = new JarAccess(this.referenceFactory, this.jarAccessUtils, this, null, null, this.path + "!/" + je.getName(), this.source + je.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, je);
                consumer.accept(child);
            }
        });
    }

    public void forEachEntry(ThrowingConsumer<EntryAccess, Exception> consumer) {
        this.doWithJarReopen(self -> {
            for (JarEntry je : Collections.list(self.getJarFile().entries())) {
                if (je.isDirectory()) continue;
                JarAccess child = new JarAccess(this.referenceFactory, this.jarAccessUtils, this, null, null, this.path + "!/" + je.getName(), this.source + je.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, je);
                consumer.accept(child.entryAccess());
            }
        });
    }

    public void forEachManifestClassPathEntry(ThrowingConsumer<String, Exception> consumer) {
        this.doWithJarReopen(self -> {
            File file = new File(self.getJarFile().getName());
            File parentFile = file.getParentFile();
            String absolutePath = parentFile != null ? parentFile.getAbsolutePath() + File.separator : "";
            for (String s : this.getJarLocalClassPath(this.getJarFile()).stream().map(suffix -> absolutePath + suffix).collect(Collectors.toList())) {
                consumer.accept(s);
            }
        });
    }

    public InitiatedBy getInitiatedBy() {
        return this.initiatedBy;
    }

    public int getNestingLevel() {
        int level = 0;
        for (JarAccess c = this.parent.get(); level < 99 && c != null; ++level, c = c.getParentJarAccess()) {
        }
        return level;
    }

    public long requiredTempfsSpaceWithParents() {
        return this.requiredTempfsSpace() + (this.parent.get() != null ? this.parent.get().requiredTempfsSpaceWithParents() : 0L);
    }

    public boolean equals(Object o) {
        if (o instanceof JarAccess) {
            return Objects.equals(this.getPath(), ((JarAccess)o).getPath()) && Objects.equals(this.getURL(), ((JarAccess)o).getURL()) && Objects.equals(this.getSource(), ((JarAccess)o).getSource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getPath()) ^ Objects.hashCode(this.getURL()) ^ Objects.hashCode(this.getSource());
    }

    private void reopenJar() throws IOException {
        this.logger.trace("reopening jar: %s; by file name: %s", this, this.getJarFile().getName());
        this.actualJar = this.referenceFactory.createNewReference(new JarFile(this.getJarFile().getName(), false));
    }

    private void doWithJarReopen(ThrowingConsumer<JarAccess, Exception> closure) {
        int count = 0;
        try {
            Exception lastException;
            while (true) {
                lastException = null;
                ++count;
                try {
                    this.referenceFactory.oomSafeRunThrowing(() -> closure.accept(this));
                }
                catch (InsufficientMemoryException e) {
                    throw e;
                }
                catch (Exception e) {
                    lastException = e;
                    if (!(e instanceof IOException || e instanceof JDKAccessor.ZipFileInconsistentException || ZipTools.ZipFileClosedException.isZipFileClosedException(e))) {
                        throw e;
                    }
                    this.reopenJar();
                    if (count < 3) continue;
                }
                break;
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        catch (InsufficientMemoryException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("doWithJarReopen failed for url=%s after %d attempt with exception=%s", this.getURL(), count, e);
            throw new RuntimeException("Wrapper:", e);
        }
    }

    private Collection<String> getJarManifestAttributeAsList(JarFile jarFile, String property) {
        try {
            if (jarFile == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes().getValue(property) == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(jarFile.getManifest().getMainAttributes().getValue(property).split("[ :]"));
        }
        catch (Exception e) {
            this.logger.debug("Failed to get manifest attributes %s from jar %s due to exception: %s", property, com.azul.crs.javaagent.client.util.Utils.toStringWithIdentityHash(jarFile), e);
            return Collections.emptyList();
        }
    }

    private Collection<String> getJarLocalClassPath(JarFile jarFile) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getJarManifestAttributeAsList(jarFile, "Class-Path"));
        result.addAll(this.getJarManifestAttributeAsList(jarFile, "Boot-Class-Path"));
        return result;
    }

    public String toString() {
        return "JarAccess[parent=" + Objects.toString(this.parent) + ", url=" + this.url + ", originJar=" + this.originJar.get() + ":" + (this.originJar.get() == null ? null : this.originJar.get().getName()) + ", actualJar=" + this.actualJar.get() + ":" + (this.actualJar.get() == null ? null : this.actualJar.get().getName()) + ", className=" + (this.originJar.get() == null ? null : this.originJar.get().getClass().getName()) + ", path=" + this.path + ", source=" + this.source + ", hash=" + this.hash + ", sizeRequired=" + this.requiredTempfsSpace() + ", cache=" + Objects.toString(this.cache.get()) + "]";
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccess.class);
    }

    private class CentralDirectoryHashNotInitializedException
    extends RuntimeException {
        public CentralDirectoryHashNotInitializedException(String s) {
            super(s);
        }
    }

    public static class Cache {
        public VMEvent vmEvent;
        public DataEntriesMap<VMEventHelper.Hashes> entriesMap;
        public ClassMethodsMap classMethodsMap = new ClassMethodsMap();

        private String printEventDetails() {
            if (this.vmEvent == null) {
                return "null";
            }
            if (this.vmEvent.getEventPayload() == null) {
                return "<no-payload>";
            }
            if (!(this.vmEvent.getEventPayload() instanceof Map)) {
                return "<type:" + this.vmEvent.getEventPayload().getClass().getName() + ">";
            }
            Map payload = (Map)this.vmEvent.getEventPayload();
            return "[extractionMethod=" + payload.get("centralDirectoryExtractionMethod") + ", depth=" + payload.get("recursionDepth") + "]";
        }

        public String toString() {
            return "Cache[entries=" + (this.entriesMap == null ? null : Integer.valueOf(this.entriesMap.size())) + ", vmevent/details=" + this.printEventDetails() + "]";
        }
    }

    public class EntryAccess {
        public String getName() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getName();
        }

        public long getCrc() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getCrc();
        }

        public void withInputStream(ThrowingConsumer<InputStream, Exception> consumer) {
            Reference thisJarEntry = JarAccess.this.jarEntry;
            ((JarAccess)JarAccess.this.parent.get()).doWithJarReopen(parent -> {
                try (InputStream inputStream = parent.getJarFile().getInputStream((ZipEntry)thisJarEntry.get());){
                    consumer.accept(inputStream);
                }
            });
        }

        public long getSize() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getSize();
        }
    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        SERVER_REQUEST,
        CLASS_PATH_ENTRY,
        CLASS_PATH_ENTRY_BY_MANIFEST,
        OTHER;

    }
}

