/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.jars.JarAccess;
import com.azul.crs.javaagent.client.jars.JarCache;
import com.azul.crs.javaagent.client.jars.JarSource;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.util.JarAccessUtils;
import com.azul.crs.javaagent.client.util.Utils;
import com.azul.crs.javaagent.jar.ZipTools;
import com.azul.crs.javaagent.runtime.utils.URLHelper;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.jar.JarFile;

public class JarAccessFactory {
    final Logger logger = Logger.getLogger(this.getClass());
    private final ReferenceFactory referenceFactory;
    private final Reference<JarCache> cache;
    private final JarAccessUtils jarAccessUtils;

    public JarAccessFactory(ReferenceFactory referenceFactory, int cacheSize, ZipTools zt, MessageDigest digest) {
        this.referenceFactory = referenceFactory;
        this.jarAccessUtils = new JarAccessUtils(zt, digest);
        this.cache = referenceFactory.createNewReference(new JarCache(cacheSize));
    }

    private JarAccess create(JarFile jar, JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        String path;
        URL url = jarSource.getUrl();
        String source = url.toString();
        String string = path = jar != null ? jar.getName() : null;
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("create jarAccess from: (jar=%s, url=%s, path=%s, source=%s, initiatedBy=%s)", new Object[]{Utils.toStringWithIdentityHash(jar), url, path, source, initiatedBy});
        }
        if (this.cache.get().isPathKnown(path) || this.cache.get().isURLKnown(url) || this.cache.get().isSourceKnown(source)) {
            this.logger.trace("Skip already known JAR reporting: %s (path: %s, source: %s, jar: %s)", url, path, source, Utils.toStringWithIdentityHash(jar));
            return null;
        }
        try {
            if (!ZipTools.isJDKNative(jar)) {
                path = URLHelper.extractContainerPathFromURL(url.toString()).replaceAll("!/.*$", "");
                url = new URL("jar:file:" + path + "!/");
                source = url.toString();
                jar = new JarFile(path, false);
                JarSource js = new JarSource.Builder().fromUrl(url).build();
                if (js != null) {
                    return this.create(jar, js, initiatedBy);
                }
                throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jar) + ", url=" + url + ", source=" + source + ", path=" + path);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jar) + ", url=" + url + ", source=" + source + ", path=" + path, e);
        }
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("before creating jarAccess: %s, %s, %s, %s, %s", new Object[]{this, Utils.toStringWithIdentityHash(jar), url, path, source, initiatedBy});
        }
        JarAccess jarAccess = new JarAccess(this.referenceFactory, this.jarAccessUtils, jar, jarSource, path, initiatedBy);
        this.cache.get().put(jarAccess);
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("created jarAccess: %s", jarAccess);
        }
        return jarAccess;
    }

    private JarAccess createSafe(JarFile jar, JarSource source, JarAccess.InitiatedBy initiatedBy) {
        if (source == null) {
            throw new RuntimeException("Source can not be null");
        }
        if (initiatedBy == null) {
            throw new RuntimeException("InitiatedBy can not be null");
        }
        URL url = source.getUrl();
        if (url == null) {
            throw new RuntimeException("URL in JarSource can not be null");
        }
        jar = jar != null ? jar : this.getJar(url);
        return this.create(jar, source, initiatedBy);
    }

    private JarFile getJar(URL url) {
        try {
            return ((JarURLConnection)url.openConnection()).getJarFile();
        }
        catch (Exception e) {
            this.logger.debug("Failed to get jar file by url='%s', e='%s'", url, e);
            return null;
        }
    }

    public synchronized JarAccess create(JarSource jarSource, JarFile jar) {
        return this.createSafe(jar, jarSource, ZipTools.isJDKNative(jar) ? JarAccess.InitiatedBy.JDK_NATIVE_LOADING : JarAccess.InitiatedBy.OTHER);
    }

    public synchronized JarAccess create(JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        return this.createSafe(null, jarSource, initiatedBy);
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccessFactory.class);
    }
}

