/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.jars.JarAccess;
import com.azul.crs.javaagent.client.util.LRU;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JarCache {
    final Logger logger = Logger.getLogger(this.getClass());
    private final Map<String, JarAccess> fromCacheByPath = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheByHash = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheByURL = new HashMap<String, JarAccess>();
    private final Map<String, JarAccess> fromCacheBySource = new HashMap<String, JarAccess>();
    private final LRU<JarAccess> lruJarAccess;

    public JarCache(int jarCacheSize) {
        this.lruJarAccess = new LRU<JarAccess>(jarCacheSize, ja -> {
            if (ja.getPath() != null) {
                this.fromCacheByPath.put(ja.getPath(), (JarAccess)ja);
            }
            if (ja.getHashLazy() != null) {
                this.fromCacheByHash.put(ja.getHashLazy(), (JarAccess)ja);
            }
            if (ja.getURL() != null) {
                this.fromCacheByURL.put(ja.getURL().toString(), (JarAccess)ja);
            }
            if (ja.getSource() != null) {
                this.fromCacheBySource.put(ja.getSource(), (JarAccess)ja);
            }
        }, ja -> {
            if (ja.getPath() != null) {
                this.fromCacheByPath.remove(ja.getPath());
            }
            if (ja.getHashLazy() != null) {
                this.fromCacheByHash.remove(ja.getHashLazy());
            }
            if (ja.getURL() != null) {
                this.fromCacheByURL.remove(ja.getURL().toString());
            }
            if (ja.getSource() != null) {
                this.fromCacheBySource.remove(ja.getSource());
            }
        });
    }

    private JarAccess byPath(String path) {
        return this.fromCacheByPath.get(path);
    }

    private JarAccess byHash(String hash) {
        if (hash == null) {
            return null;
        }
        return this.fromCacheByHash.get(hash);
    }

    private JarAccess byURL(URL url) {
        return this.fromCacheByURL.get(url.toString());
    }

    private JarAccess bySource(String source) {
        return this.fromCacheBySource.get(source);
    }

    public boolean isPathKnown(String path) {
        return this.byPath(path) != null;
    }

    public boolean isHashKnown(String hash) {
        return this.byHash(hash) != null;
    }

    public boolean isURLKnown(URL url) {
        return this.byURL(url) != null;
    }

    public boolean isSourceKnown(String source) {
        return this.bySource(source) != null;
    }

    public boolean isKnown(JarAccess jarAccess) {
        return this.isHashKnown(jarAccess.getHashLazy()) || this.isSourceKnown(jarAccess.getSource()) || this.isURLKnown(jarAccess.getURL()) || this.isPathKnown(jarAccess.getPath());
    }

    public void put(JarAccess ja) {
        this.logger.trace("JarCache.put: %s", ja);
        this.lruJarAccess.put(ja);
    }
}

