/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.jars.JarURLFactory;
import com.azul.crs.javaagent.client.jars.SourceCache;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.URL;

public class JarSource {
    private static Logger logger = Logger.getLogger(JarSource.class);
    private final String source;
    private final URL originalUrl;
    private final URL url;

    private JarSource(String source, URL originalUrl, URL url) {
        this.source = source;
        this.originalUrl = originalUrl;
        this.url = url;
    }

    public String getSource() {
        return this.source;
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return "JarSource[source=" + this.source + ", originalUrl=" + this.originalUrl + ", url=" + this.url + ']';
    }

    public static final class Builder {
        private String source;
        private URL url;
        private boolean fromSource = false;
        private boolean fromUrl = false;
        private SourceCache sourceCache;

        public Builder fromSource(String source) {
            if (this.fromUrl) {
                throw new RuntimeException("Invalid build step to create JarSource from source.");
            }
            this.fromSource = true;
            this.source = source;
            return this;
        }

        public Builder fromUrl(URL url) {
            if (this.fromSource) {
                throw new RuntimeException("Invalid build step to create JarSource from url.");
            }
            this.fromUrl = true;
            this.url = url;
            return this;
        }

        public JarSource build() {
            if (this.fromSource) {
                URL normalizedUrl = JarURLFactory.createURL(this.source, this.sourceCache);
                if (normalizedUrl == null) {
                    logger.trace("Can not create URL from source=%s", this.source);
                    return null;
                }
                return new JarSource(this.source, null, normalizedUrl);
            }
            if (this.fromUrl) {
                URL normalizedUrl = JarURLFactory.createURL(this.url.toString(), this.sourceCache);
                if (normalizedUrl == null) {
                    logger.trace("Can not create URL from url=%s", this.url);
                    return null;
                }
                return new JarSource(null, this.url, normalizedUrl);
            }
            throw new RuntimeException("Invalid JarSource builder ... ");
        }

        public Builder withCache(SourceCache sourceCache) {
            this.sourceCache = sourceCache;
            return this;
        }
    }
}

