/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.jars.SourceCache;
import com.azul.crs.javaagent.runtime.utils.KnownAzulRuntimeContainers;
import com.azul.crs.javaagent.runtime.utils.URLHelper;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class JarURLFactory {
    private static final Logger logger = Logger.getLogger(JarURLFactory.class);
    private static final Set<String> knownVmJars = JarURLFactory.initKnownVmJars();

    public JarURLFactory() {
        if (Tweaks.DEBUG_JARLOAD) {
            for (String s : knownVmJars) {
                logger.trace("known jar = %s", s);
            }
        }
    }

    private static Set<String> initKnownVmJars() {
        String javaHome = System.getProperty("java.home");
        String specVersion = System.getProperty("java.specification.version");
        return KnownAzulRuntimeContainers.get(javaHome, specVersion);
    }

    public static boolean isVmKnownJar(String jar) {
        return knownVmJars.contains(jar);
    }

    public static URL createURL(String source, SourceCache sourceCache) {
        if (source == null) {
            return null;
        }
        String normalized = URLHelper.toNormalizedJarURL(source);
        if (sourceCache != null && !sourceCache.add(normalized)) {
            return null;
        }
        String path = URLHelper.extractContainerPathFromURL(normalized);
        if (JarURLFactory.isVmKnownJar(path)) {
            logger.trace("Skip VM JAR reporting: source(%s) containerId(%s)", source, path);
            return null;
        }
        if (new File(path).exists()) {
            return JarURLFactory.toURL("jar:file:" + path + "!/");
        }
        return JarURLFactory.toURL(normalized);
    }

    static URL createURL(String source) {
        return JarURLFactory.createURL(source, null);
    }

    private static URL toURL(String source) {
        try {
            return new URL(source);
        }
        catch (MalformedURLException e) {
            logger.debug("Failed to convert source(%s) to url (stacktrace: %s)", source, new RuntimeException("debug stacktrace"));
            return null;
        }
    }
}

