/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.util.LRU;
import java.util.HashSet;
import java.util.Set;

public class SourceCache {
    private final Reference<LRU<String>> cache;
    private final Reference<Set<String>> byUrl;

    public SourceCache(ReferenceFactory referenceFactory, int cacheSize) {
        this.byUrl = referenceFactory.createNewReference(new HashSet());
        this.cache = referenceFactory.createNewReference(new LRU<String>(cacheSize, v -> this.byUrl.get().add((String)v), v -> this.byUrl.get().remove(v)));
    }

    public synchronized boolean add(String url) {
        if (this.cache.get().contains(url)) {
            return false;
        }
        this.cache.get().put(url);
        return true;
    }
}

