/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars;

import com.azul.crs.javaagent.client.Inventory;
import com.azul.crs.javaagent.client.Options;
import com.azul.crs.javaagent.client.Tweaks;
import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.eventconsumer.VmEventConsumer;
import com.azul.crs.javaagent.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.javaagent.client.jars.JarAccess;
import com.azul.crs.javaagent.client.jars.VmJarInfoRequestSupport;
import com.azul.crs.javaagent.client.jars.classmethods.ClassMethodsDetector;
import com.azul.crs.javaagent.client.models.VMArtifact;
import com.azul.crs.javaagent.client.models.VMEvent;
import com.azul.crs.javaagent.client.service.DataWriter;
import com.azul.crs.javaagent.client.util.ThrowingBiConsumer;
import com.azul.crs.javaagent.digest.Digest;
import com.azul.crs.javaagent.digest.ShadedClassHashCalculator;
import com.azul.crs.javaagent.runtime.utils.ClassMethodsMap;
import com.azul.crs.javaagent.runtime.utils.DataEntriesMap;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class VMEventHelper {
    private static final int VM_JAR_LOADED_EVENT_INLINE_PAYLOAD_THRESHOLD = 524288;
    private static boolean syncUploadFailedNotSent = true;
    private static boolean methodDetectionFailedNotSent = true;
    private static boolean calculatingShadedHashNotSent = true;

    static Logger logger() {
        return Logger.getLogger(VMEventHelper.class);
    }

    public static VMEvent jarLoadEventWithError(VMEvent vmJarLoadedEvent, JarAccess jarAccess, JarLoadProcessingError error, Exception cause) {
        if (vmJarLoadedEvent == null) {
            vmJarLoadedEvent = VMEventHelper.prepareMinimalEvent(jarAccess);
        }
        Map eventPayload = (Map)vmJarLoadedEvent.getEventPayload();
        eventPayload.remove("entries");
        eventPayload.put("entries", new HashSet());
        eventPayload.remove("requestCookie");
        eventPayload.put("error", error);
        eventPayload.put("cause", com.azul.crs.javaagent.client.util.Utils.toStringWithCause(cause));
        return vmJarLoadedEvent;
    }

    private static InputStream wrapStream(InputStream inputStream, Digest digest) {
        return new DigestInputStream(inputStream, digest.getMessageDigest()){

            @Override
            public long skip(long n) throws IOException {
                int r;
                long remaining;
                if (n <= 0L) {
                    return 0L;
                }
                int size = (int)Math.min(2048L, remaining);
                byte[] skipBuffer = new byte[size];
                for (remaining = n; remaining > 0L && (r = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)r) {
                }
                return n - remaining;
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
    }

    private static VMEvent updateJarLoadedEvent(VMEvent jarLoadedEvent, String url, JarAccess.InitiatedBy initiatedBy, Integer recursionDepth, String jarName, Long eventTime, String hashString, String manifestHashString, String centralDirectoryProvider, Long centralDirectoryLength, List<String> entries, Set<MavenComponent> mavenComponents, Map<String, Long> stats, String parentCentralDirectoryHash, Long parentCentralDirectoryLength, ClassMethodsMap classMethodsMap) {
        Map<String, String> payload;
        Map map = payload = jarLoadedEvent == null ? new HashMap() : (Map)jarLoadedEvent.getEventPayload();
        if (url != null) {
            payload.put("url", url);
        }
        if (jarName != null) {
            payload.put("jarName", jarName);
        }
        if (hashString != null) {
            payload.put("centralDirectoryHash", hashString);
        }
        if (manifestHashString != null) {
            payload.put("manifestHash", manifestHashString);
        }
        if (centralDirectoryProvider != null) {
            payload.put("centralDirectoryExtractionMethod", centralDirectoryProvider);
        }
        if (centralDirectoryLength != null) {
            payload.put("centralDirectoryLength", centralDirectoryLength != null ? Long.toString(centralDirectoryLength) : null);
        }
        if (entries != null) {
            payload.put("entries", (String)((Object)entries));
        }
        if (classMethodsMap != null && !classMethodsMap.getMap().isEmpty()) {
            payload.put("methods", (String)((Object)classMethodsMap.getMap()));
        }
        if (initiatedBy != null) {
            payload.put("initiatedBy", (String)((Object)initiatedBy));
        }
        if (recursionDepth != null) {
            payload.put("recursionDepth", (String)((Object)recursionDepth));
        }
        if (mavenComponents != null) {
            payload.put("mavenComponents", (String)((Object)mavenComponents));
        }
        if (stats != null) {
            payload.put("stats", (String)((Object)stats));
        }
        if (parentCentralDirectoryHash != null) {
            payload.put("parentCentralDirectoryHash", parentCentralDirectoryHash);
        }
        if (parentCentralDirectoryLength != null) {
            payload.put("parentCentralDirectoryLength", parentCentralDirectoryLength != null ? Long.toString(parentCentralDirectoryLength) : null);
        }
        if (jarLoadedEvent == null) {
            jarLoadedEvent = new VMEvent();
        }
        jarLoadedEvent.eventType(VMEvent.Type.VM_JAR_LOADED);
        if (eventTime != null) {
            jarLoadedEvent.eventTime(eventTime);
        }
        jarLoadedEvent.eventPayload(payload);
        return jarLoadedEvent;
    }

    public static VMEvent prepareMinimalEvent(JarAccess jarAccess) {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        HashSet<MavenComponent> mavenComponents = new HashSet<MavenComponent>();
        String centralDirectoryHashString = null;
        String manifestHashString = null;
        String centralDirectoryProvider = null;
        Long centralDirectoryLength = null;
        String parentCentralDirectoryHashString = null;
        Long parentCentralDirectoryLength = null;
        if (Tweaks.sendCentralDirectoryHash) {
            centralDirectoryHashString = jarAccess.getHash();
            manifestHashString = jarAccess.getManifesthash();
            if (jarAccess.getJarShortDigest() != null) {
                centralDirectoryProvider = jarAccess.getJarShortDigest().getProvider();
                centralDirectoryLength = jarAccess.getJarShortDigest().getCentralDirectoryLength();
            } else {
                new RuntimeException("(no central directory hash in minimal event) debug me: " + jarAccess).printStackTrace();
            }
            if (jarAccess.getParentJarAccess() != null) {
                parentCentralDirectoryHashString = jarAccess.getParentJarAccess().getHash();
                parentCentralDirectoryLength = jarAccess.getParentJarAccess().getJarShortDigest().getCentralDirectoryLength();
                DataEntriesMap.DataEntry entry = jarAccess.getParentJarAccess().getCache().entriesMap.getEntry(jarAccess.entryAccess().getName());
                entry.put(Hashes.ENTRY_CD, jarAccess.getHash());
                entry.put(Hashes.ENTRY_CD_LENGTH, String.valueOf(jarAccess.getJarShortDigest().getCentralDirectoryLength()));
            }
        }
        long vmEventTimestamp = Utils.currentTimeMillis();
        DataEntriesMap<Hashes> entriesMap = new DataEntriesMap<Hashes>(Hashes.class);
        VMEvent vmJarLoadedEvent = VMEventHelper.updateJarLoadedEvent(null, jarAccess.getUrlOrSourceOrNull(), jarAccess.getInitiatedBy(), jarAccess.getNestingLevel(), jarAccess.getJarName(), vmEventTimestamp, centralDirectoryHashString, manifestHashString, centralDirectoryProvider, centralDirectoryLength, entriesMap.pack().toExternalForm(), mavenComponents, stats, parentCentralDirectoryHashString, parentCentralDirectoryLength, null);
        VmJarInfoRequestSupport.VmJarInfoRequestCookie cookie = new VmJarInfoRequestSupport.VmJarInfoRequestCookie(jarAccess.getJarName(), jarAccess.getPath(), centralDirectoryHashString);
        ((Map)vmJarLoadedEvent.getEventPayload()).put("requestCookie", cookie.encode());
        jarAccess.getCache().entriesMap = entriesMap;
        jarAccess.getCache().vmEvent = vmJarLoadedEvent;
        return vmJarLoadedEvent;
    }

    private static void prepareVMJarLoadedEventDetails(DataEntriesMap<Hashes> entriesMap, Set<MavenComponent> mavenComponents, Map<String, Long> stats, ClassMethodsMap classMethodsMap, JarAccess jarAccess) {
        ArrayList<Consumer<JarAccess.EntryAccess>> visitors = new ArrayList<Consumer<JarAccess.EntryAccess>>();
        AtomicLong sendJarEntriesHashesTime = new AtomicLong();
        boolean sendPOMProperties = Options.sendPOMData.isYes();
        AtomicLong artificialId = new AtomicLong(1L);
        if (Tweaks.sendJarEntriesHashes) {
            visitors.add(e -> {
                sendJarEntriesHashesTime.addAndGet(-System.nanoTime());
                try {
                    DataEntriesMap.DataEntry entry = entriesMap.getEntry(e.getName());
                    entry.put(Hashes.ENTRY_CRC32, String.format("%08x", e.getCrc()));
                    entry.put(Hashes.ENTRY_SIZE, Long.toString(e.getSize()));
                }
                finally {
                    sendJarEntriesHashesTime.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong sendJarEntriesShadedHashesTime = new AtomicLong();
        if (Tweaks.sendJarEntriesShadedHashes) {
            visitors.add(e -> {
                sendJarEntriesShadedHashesTime.addAndGet(-System.nanoTime());
                try {
                    String name = e.getName();
                    if (name.endsWith(".class")) {
                        try {
                            Digest sha256 = Digest.get();
                            Digest shadedHash = Digest.get();
                            e.withInputStream(is -> {
                                InputStream bis = new BufferedInputStream((InputStream)is);
                                bis = VMEventHelper.wrapStream(bis, sha256);
                                ShadedClassHashCalculator.updateHash(bis, shadedHash);
                                entriesMap.put(name, Hashes.CLASS_SHADED_HASH, shadedHash.asHexString());
                                bis.skip(Long.MAX_VALUE);
                                entriesMap.put(name, Hashes.SHA256, sha256.asHexString());
                            });
                        }
                        catch (Exception ex) {
                            if (calculatingShadedHashNotSent) {
                                VMEventHelper.logger().error("Calculating shaded hash of class %s failed with exception: %s", name, ex);
                                calculatingShadedHashNotSent = false;
                            } else {
                                VMEventHelper.logger().debug("Calculating shaded hash of class %s failed with exception: %s", name, ex);
                            }
                            entriesMap.put(name, Hashes.SHA256, "0000000000000000000000000000000000000000000000000000000000000000");
                        }
                    }
                }
                finally {
                    sendJarEntriesShadedHashesTime.addAndGet(System.nanoTime());
                }
            });
        }
        AtomicLong sendJarMethodsTime = new AtomicLong();
        if (Tweaks.sendClassMethods || FeatureFlagsConfiguration.notifyClassMethods()) {
            visitors.add(e -> {
                block6: {
                    sendJarMethodsTime.addAndGet(-System.nanoTime());
                    try {
                        String name = e.getName();
                        if (!name.endsWith(".class")) break block6;
                        try {
                            e.withInputStream(is -> {
                                long id = artificialId.getAndIncrement();
                                List<String> methods = ClassMethodsDetector.detect(name, is);
                                if (!methods.isEmpty()) {
                                    classMethodsMap.add(id, methods);
                                }
                                entriesMap.put(name, Hashes.CLASS_ID, String.valueOf(id));
                            });
                        }
                        catch (Exception ex) {
                            if (methodDetectionFailedNotSent) {
                                VMEventHelper.logger().error("Method detection for class %s failed with exception: %s", name, ex);
                                methodDetectionFailedNotSent = false;
                                break block6;
                            }
                            VMEventHelper.logger().debug("Method detection for class %s failed with exception: %s", name, ex);
                        }
                    }
                    finally {
                        sendJarMethodsTime.addAndGet(System.nanoTime());
                    }
                }
            });
        }
        AtomicLong pomPropertiesTime = new AtomicLong();
        if (sendPOMProperties) {
            visitors.add(e -> {
                pomPropertiesTime.addAndGet(-System.nanoTime());
                try {
                    if (e.getName().endsWith("/pom.properties")) {
                        MavenComponent mavenComponent = new MavenComponent();
                        try {
                            e.withInputStream(is -> {
                                mavenComponent.load((InputStream)is);
                                mavenComponents.add(mavenComponent);
                            });
                        }
                        catch (Exception ex) {
                            VMEventHelper.logger().warning("Failed to read %s: %s", e.getName(), ex.toString());
                        }
                    }
                }
                finally {
                    pomPropertiesTime.addAndGet(System.nanoTime());
                }
            });
        }
        long start_ts = System.nanoTime();
        jarAccess.forEachEntry(e -> {
            for (Consumer v : visitors) {
                v.accept(e);
            }
        });
        stats.put("visitJarEntries", System.nanoTime() - start_ts);
        stats.put("jarEntriesShaded", sendJarEntriesShadedHashesTime.get());
        stats.put("jarEntriesHashes", sendJarEntriesHashesTime.get());
        if (Tweaks.sendClassMethods || FeatureFlagsConfiguration.notifyClassMethods()) {
            stats.put("jarMethods", sendJarMethodsTime.get());
        }
        if (sendPOMProperties) {
            stats.put("pomProperties", pomPropertiesTime.get());
        }
    }

    public static void prepareDetailed(VMEvent vmEvent, JarAccess jarAccess) {
        if (vmEvent == null) {
            vmEvent = VMEventHelper.prepareMinimalEvent(jarAccess);
        }
        vmEvent.onSuccess(null).onError(null);
        Map eventPayload = (Map)vmEvent.getEventPayload();
        eventPayload.remove("requestCookie");
        HashSet<MavenComponent> mavenComponents = new HashSet<MavenComponent>();
        HashMap<String, Long> stats = new HashMap<String, Long>();
        VMEventHelper.prepareVMJarLoadedEventDetails(jarAccess.getCache().entriesMap, mavenComponents, stats, jarAccess.getCache().classMethodsMap, jarAccess);
        VMEventHelper.updateJarLoadedEvent(vmEvent, null, jarAccess.getInitiatedBy(), null, null, null, null, null, null, null, jarAccess.getCache().entriesMap.pack().toExternalForm(), mavenComponents, stats, null, null, jarAccess.getCache().classMethodsMap);
    }

    private static void syncUpload(VmEventConsumer eventConsumer, final String name, VMArtifact.Type type, Map<String, Object> metadata, final ThrowingBiConsumer<Integer, OutputStream, IOException> writer) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Object> e = new AtomicReference<Object>(null);
        final AtomicBoolean success = new AtomicBoolean(false);
        final int artifactId = eventConsumer.createArtifactId();
        eventConsumer.consumeVMArtifact(type, artifactId, metadata, new DataWriter(){

            @Override
            public void writeData(OutputStream output) throws IOException {
                try {
                    writer.accept(artifactId, output);
                    success.set(true);
                }
                catch (IOException ex) {
                    this.handleException(ex);
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void handleException(Exception ex) {
                e.set(ex);
                if (syncUploadFailedNotSent) {
                    VMEventHelper.logger().error("syncUpload for %s failed: %s", name, ex);
                    syncUploadFailedNotSent = false;
                } else {
                    VMEventHelper.logger().debug("syncUpload for %s failed: %s", name, ex);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
            Exception ex = e.get();
            if (ex != null) {
                VMEventHelper.logger().trace("syncUpload after lock.await for %s with exception=%s", name, ex);
            }
        }
        catch (InterruptedException ex) {
            VMEventHelper.logger().warning("syncUpload for %s interrupted", name);
        }
    }

    public static void postVMJarLoadedEvent(VmEventConsumer eventConsumer, VMEvent vmJarLoadedEvent) {
        int eventSize;
        boolean isHugeEvent;
        if (Tweaks.DEBUG_JARLOAD) {
            VMEventHelper.logger().trace("postVMJarLoadedEvent: %s", vmJarLoadedEvent);
        }
        boolean bl = isHugeEvent = (eventSize = vmJarLoadedEvent.toJson().length()) > 524288;
        if (!isHugeEvent) {
            eventConsumer.consumeVMEvent(vmJarLoadedEvent);
            return;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("eventId", vmJarLoadedEvent.getEventId());
        metadata.put("tags", Inventory.instanceTags());
        VMEventHelper.syncUpload(eventConsumer, "VM_JAR_LOADED event" + vmJarLoadedEvent.getEventId(), VMArtifact.Type.LARGE_VM_EVENT, metadata, (artifactId, output) -> {
            PrintStream printStream = new PrintStream((OutputStream)output);
            Utils.serializer.serialize(printStream, (Object)vmJarLoadedEvent);
            Map eventPayload = (Map)vmJarLoadedEvent.getEventPayload();
            eventPayload.remove("entries");
            eventPayload.remove("methods");
            eventPayload.put("STORED_VM_JAR_LOADED_EVENT", eventConsumer.artifactIdToString((int)artifactId));
            eventConsumer.consumeVMEvent(vmJarLoadedEvent);
        });
    }

    private static final class MavenComponent
    extends Properties {
        private MavenComponent() {
        }
    }

    static enum Hashes {
        ENTRY_CRC32,
        ENTRY_SIZE,
        SHA256,
        CLASS_SHADED_HASH,
        ENTRY_CD,
        ENTRY_CD_LENGTH,
        CLASS_ID;

    }

    public static enum JarLoadProcessingError {
        TEMPFS_LIMIT,
        EXCEPTION,
        NESTED_JAR,
        SEND_FAILED,
        OTHER;

    }
}

