/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars.classmethods;

import com.azul.crs.javaagent.internal.asm.ClassReader;
import com.azul.crs.javaagent.internal.asm.ClassVisitor;
import com.azul.crs.javaagent.internal.asm.MethodVisitor;
import com.azul.crs.javaagent.util.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ClassMethodsDetector {
    private static final Logger logger = Logger.getLogger(ClassMethodsDetector.class);

    public static List<String> detect(String className, InputStream is) {
        final ArrayList<String> result = new ArrayList<String>();
        try {
            ClassReader cr = new ClassReader(is);
            ClassVisitor visitor = new ClassVisitor(589824, null){

                @Override
                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    if ((access & 0x100) != 0 || (access & 0x400) != 0) {
                        return super.visitMethod(access, name, descriptor, signature, exceptions);
                    }
                    result.add(name + descriptor);
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }
            };
            cr.accept(visitor, 0);
            return result;
        }
        catch (IOException e) {
            logger.debug("Can not detect the methods for class:%s", className);
            return result;
        }
    }
}

