/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.jars.tracker;

import com.azul.crs.javaagent.client.jars.tracker.JarDetailsEnum;
import com.azul.crs.javaagent.client.jars.tracker.JarProcessingStatusEnum;
import com.azul.crs.javaagent.client.jars.tracker.JarTrackerEnum;
import com.azul.crs.javaagent.client.jars.tracker.JarUnfinishedReasonEnum;
import com.azul.crs.javaagent.util.logging.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class JarTracker {
    private final Logger logger = Logger.getLogger(JarTracker.class);
    private JarFile jar;
    private URL url;
    private String path;
    private JarTrackerEnum state = JarTrackerEnum.NONE;
    private JarDetailsEnum jarDetails = JarDetailsEnum.NO_INFO;
    private JarUnfinishedReasonEnum unfinishedReason = JarUnfinishedReasonEnum.WAITING_FOR_EXECUTOR;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private JarProcessingStatusEnum processingStatus = JarProcessingStatusEnum.IN_PROGRESS;

    public JarTracker(JarFile jar, URL url, String path) {
        this.jar = jar;
        this.url = url;
        this.path = path;
    }

    public void info() {
        this.logger.info(this.getMessage(), new Object[0]);
    }

    public void trace(JarTrackerEnum state) {
        this.state = state;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public void unfinished(JarUnfinishedReasonEnum reason) {
        this.unfinishedReason = reason;
        this.processingStatus = JarProcessingStatusEnum.IN_PROGRESS;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    private String getJarName() {
        return this.jar != null ? this.jar.getName() : null;
    }

    private String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("JarTracker [name=").append(this.getJarName()).append(", url=").append(this.url).append(", path=").append(this.path).append("] ").append((Object)this.processingStatus).append(" ");
        if (this.processingStatus == JarProcessingStatusEnum.IN_PROGRESS) {
            sb.append("[").append((Object)this.unfinishedReason).append("] ");
        }
        sb.append("status=").append((Object)this.state).append(", details=").append((Object)this.jarDetails);
        if (this.exceptions.size() > 0) {
            sb.append(",\n" + this.exceptions.stream().map(e -> Objects.toString(e)).collect(Collectors.joining("\n\t", "exceptions: \n\t", "")));
        }
        return sb.toString();
    }

    public void traceDetails(JarDetailsEnum jarDetailsEnum) {
        this.jarDetails = jarDetailsEnum;
    }

    public void traceError(Exception e) {
        this.exceptions.add(e);
    }

    public void finish() {
        this.processingStatus = this.exceptions.isEmpty() ? JarProcessingStatusEnum.FINISHED : JarProcessingStatusEnum.FINISHED_WITH_ERRORS;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public void cancel(Exception e) {
        if (e != null) {
            this.exceptions.add(e);
        }
        this.processingStatus = JarProcessingStatusEnum.CANCELLED;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public boolean hasStatus(JarTrackerEnum jarTrackerEnum) {
        return this.state.equals((Object)jarTrackerEnum);
    }

    public boolean statusIn(JarTrackerEnum ... list) {
        return Arrays.stream(list).anyMatch(e -> this.hasStatus((JarTrackerEnum)((Object)e)));
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean assertStatusIn(String message, JarTrackerEnum ... list) {
        if (!this.statusIn(list)) {
            this.logger.warning("Unexpected state of %s %s: expected actual=%s, to be in [%s]", new Object[]{this, message, this.state, Arrays.stream(list).map(t -> Objects.toString(t)).collect(Collectors.joining(","))});
            return false;
        }
        return true;
    }
}

