/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.models;

import com.azul.crs.javaagent.client.Utils;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ServerRequest {
    public static final String REQUEST_COOKIE_KEY = "requestCookie";
    private static final ConcurrentHashMap<String, ServerRequestDecoder> decoders = new ConcurrentHashMap();

    protected static void registerDecoder(String id, ServerRequestDecoder decoder) {
        decoders.putIfAbsent(id, decoder);
    }

    public static ServerRequest parse(String raw) {
        ServerRequestDecoder decoder = null;
        String[] parts = raw.split("\\|", 2);
        if (parts.length == 2) {
            decoder = decoders.get(parts[0]);
        }
        return decoder == null ? null : decoder.decode(parts[1]);
    }

    public static abstract class RequestCookie<C extends RequestCookie> {
        protected final String[] data;

        public RequestCookie(String[] data) {
            this.data = data;
        }

        public final String encode() {
            String resource = String.join((CharSequence)"|", this.data);
            String digest = Utils.Digest.digestBase64(resource);
            return digest == null ? null : Base64.getEncoder().encodeToString(String.join((CharSequence)"|", digest, resource).getBytes());
        }

        public final C decode(String encoded) throws IllegalArgumentException {
            String[] d;
            String fields;
            String digest;
            String decoded = new String(Base64.getDecoder().decode(encoded));
            int idx = decoded.indexOf(124);
            if (idx > 0 && (digest = decoded.substring(0, idx)).equals(Utils.Digest.digestBase64(fields = decoded.substring(idx + 1))) && (d = fields.split("\\|")).length == this.data.length) {
                System.arraycopy(d, 0, this.data, 0, d.length);
                return (C)this;
            }
            return null;
        }
    }

    @FunctionalInterface
    protected static interface ServerRequestDecoder {
        public ServerRequest decode(String var1);
    }
}

