/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.models;

import com.azul.crs.javaagent.client.Utils;
import com.azul.crs.javaagent.client.models.Payload;
import com.azul.crs.javaagent.client.models.VMArtifact;
import com.azul.crs.javaagent.client.models.VMInstance;
import com.azul.crs.javaagent.util.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class VMEvent
extends Payload {
    private String vmId;
    private String eventId;
    private Type eventType;
    private Long eventTime;
    private Object eventPayload;
    private transient Runnable onError;
    private transient Runnable onSuccess;

    public String getVmId() {
        return this.vmId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Long getEventTime() {
        return this.eventTime;
    }

    public <T> T getEventPayload() {
        return (T)this.eventPayload;
    }

    public void setVmId(String vmId) {
        this.vmId = vmId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public void setEventType(Type eventType) {
        if (this.eventPayload != null && !eventType.payloadClass().isAssignableFrom(this.eventPayload.getClass())) {
            throw new IllegalArgumentException("Event type inconsistent with event payload type");
        }
        this.eventType = eventType;
    }

    public void setEventPayload(Object eventPayload) {
        if (this.eventType != null && !this.eventType.payloadClass().isAssignableFrom(eventPayload.getClass())) {
            throw new IllegalArgumentException("Event payload type inconsistent with event type ");
        }
        this.eventPayload = eventPayload;
    }

    public VMEvent vmId(String vmId) {
        this.setVmId(vmId);
        return this;
    }

    public VMEvent eventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public VMEvent randomEventId() {
        this.setEventId(Utils.uuid());
        return this;
    }

    public VMEvent eventType(Type eventType) {
        this.setEventType(eventType);
        return this;
    }

    public VMEvent eventType(String eventType) {
        this.setEventType(Type.valueOf(eventType));
        return this;
    }

    public VMEvent eventTime(Long eventTime) {
        this.setEventTime(eventTime);
        return this;
    }

    public VMEvent eventPayload(Object eventPayload) {
        this.setEventPayload(eventPayload);
        return this;
    }

    public VMEvent onError(Runnable e) {
        if (this.onError != null) {
            throw new RuntimeException("onError non-null");
        }
        this.onError = e;
        return this;
    }

    public VMEvent onSuccess(Runnable e) {
        if (this.onSuccess != null) {
            throw new RuntimeException("onSuccess non-null");
        }
        this.onSuccess = e;
        return this;
    }

    public VMEvent onErrorAppend(Function<Runnable, Runnable> wrapper) {
        this.onError = wrapper.apply(this.onError);
        return this;
    }

    public VMEvent onSuccessAppend(Function<Runnable, Runnable> wrapper) {
        this.onSuccess = wrapper.apply(this.onSuccess);
        return this;
    }

    public void callOnError() {
        if (this.onError != null) {
            this.onError.run();
        }
    }

    public void callOnSuccess() {
        if (this.onSuccess != null) {
            this.onSuccess.run();
        }
    }

    public static Iterator<Payload.DataWithCounters> toJsonArrays(final Collection<? extends VMEvent> events, final int stringSizeLimit) {
        return new Iterator<Payload.DataWithCounters>(){
            Iterator<? extends VMEvent> it;
            StringBuilder current;
            StringBuilder sb;
            Map<Type, Long> counters;
            Type currentEventType;
            {
                this.it = events.iterator();
                this.current = new StringBuilder();
                this.sb = new StringBuilder().append('[');
                this.counters = new HashMap<Type, Long>();
                this.currentEventType = null;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext() || this.current.length() > 0;
            }

            @Override
            public Payload.DataWithCounters next() {
                this.counters.clear();
                this.sb.setLength(1);
                this.fillNext();
                this.sb.setCharAt(this.sb.length() - 1, ']');
                return new Payload.DataWithCounters(this.sb.toString(), this.counters);
            }

            private void fillNext() {
                if (this.current.length() > 0) {
                    this.sb.append((CharSequence)this.current).append(',');
                    this.counters.compute(this.currentEventType, (k, v) -> v == null ? 1L : v + 1L);
                    this.current.setLength(0);
                }
                if (this.sb.length() < stringSizeLimit) {
                    while (this.it.hasNext()) {
                        VMEvent event = this.it.next();
                        this.currentEventType = event.getEventType();
                        Utils.serializer.serialize(this.current, (Object)event);
                        if (this.sb.length() + this.current.length() + 1 >= stringSizeLimit) {
                            if (this.current.length() + 2 >= stringSizeLimit) {
                                Logger.getLogger(Payload.class).error("Single event must not exceed %d. Current event '%s...' has length %d. The event is skipped.", stringSizeLimit, this.current.subSequence(0, Math.min(this.current.length(), 100)).toString(), this.current.length());
                                this.current.setLength(0);
                            }
                            return;
                        }
                        this.sb.append((CharSequence)this.current).append(',');
                        this.counters.compute(this.currentEventType, (k, v) -> v == null ? 1L : v + 1L);
                        this.current.setLength(0);
                    }
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VMEvent vmEvent = (VMEvent)o;
        return Objects.equals(this.vmId, vmEvent.vmId) && Objects.equals(this.eventId, vmEvent.eventId) && this.eventType == vmEvent.eventType && Objects.equals(this.eventTime, vmEvent.eventTime) && Objects.equals(this.eventPayload, vmEvent.eventPayload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vmId, this.eventId, this.eventType, this.eventTime, this.eventPayload});
    }

    @Override
    public String toString() {
        return "vmId=" + this.vmId + ", eventId=" + this.eventId + ", eventType=" + (Object)((Object)this.eventType) + ", eventTime=" + this.eventTime + ", eventPayload=" + this.eventPayload + ", onSuccessIsSet=" + (this.onSuccess != null) + ", onErrorIsSet=" + (this.onSuccess != null);
    }

    public static enum Type {
        VM_CREATE(VMInstance.class),
        VM_PATCH(VMInstance.class),
        VM_ARTIFACT_CREATE(VMArtifact.class),
        VM_ARTIFACT_PATCH(VMArtifact.class),
        VM_ARTIFACT_DATA(Map.class),
        VM_HEARTBEAT(Void.class),
        VM_SHUTDOWN(Void.class),
        VM_DISCONNECTED(Map.class),
        VM_CLASS_LOADED(Map.class),
        VM_JAR_LOADED(Map.class),
        VM_METHOD_FIRST_CALLED(Map.class),
        VM_PERFORMANCE_METRICS(Map.class),
        VM_ANY_CONNECTION(Object.class);

        private final Class payloadClass;
        private int inFlightEventsCount = 0;

        private Type(Class payloadClass) {
            this.payloadClass = payloadClass;
        }

        public Class payloadClass() {
            return this.payloadClass;
        }

        public static Type eventType(String type) {
            return type != null ? Type.valueOf(type.toUpperCase()) : null;
        }

        public synchronized int getInFlightEventsCounter() {
            return this.inFlightEventsCount;
        }

        public synchronized int incrementInFlightEventsCount() {
            ++this.inFlightEventsCount;
            return this.inFlightEventsCount;
        }

        public synchronized int subtractInFlightEventsCount(int decrement) {
            this.inFlightEventsCount -= decrement;
            if (this.inFlightEventsCount == 0) {
                ((Object)((Object)this)).notifyAll();
            }
            return this.inFlightEventsCount;
        }

        public synchronized void waitAllEventsProcessed(Utils.Deadline deadline) throws InterruptedException {
            while (this.inFlightEventsCount != 0 && !deadline.hasExpired()) {
                ((Object)((Object)this)).wait(Math.max(1L, deadline.remainder(TimeUnit.MILLISECONDS)));
            }
        }
    }
}

