/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.javaagent.client.safeguards;

import com.azul.crs.javaagent.client.safeguards.HardReference;
import com.azul.crs.javaagent.client.safeguards.Reference;
import com.azul.crs.javaagent.client.safeguards.ReferenceFactory;
import com.azul.crs.javaagent.client.safeguards.ThrowingRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class HardReferenceFactory
implements ReferenceFactory {
    static final ThreadGroup threadGroup = new ThreadGroup("CRS-agent");
    private final AtomicInteger counter = new AtomicInteger();

    @Override
    public String stats() {
        throw new RuntimeException("should not reach here");
    }

    @Override
    public void onShutdown() {
    }

    @Override
    public <T> Reference<T> createNewReference(T object) {
        return new HardReference<T>(object);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue(int size) {
        return new LinkedBlockingDeque(size);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue() {
        return new LinkedBlockingDeque();
    }

    @Override
    public ThreadFactory createThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(threadGroup, r, String.format("CRS-ES-%3d", HardReferenceFactory.this.counter.incrementAndGet()));
            }
        };
    }

    @Override
    public void oomSafeRun(Runnable runnable) {
        runnable.run();
    }

    @Override
    public <E extends Throwable> void oomSafeRunThrowing(ThrowingRunnable<E> runnable) throws E {
        runnable.run();
    }

    @Override
    public void notifyWithException(Throwable t) {
    }

    @Override
    public void ensureIsAlive() {
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return threadGroup;
    }
}

